/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.common.tile.SoulEnchanterTileEntity;
import alexthw.eidolon_repraised.util.ClientInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class SoulEnchanterTileRenderer
implements BlockEntityRenderer<SoulEnchanterTileEntity> {
    public static final ResourceLocation BOOK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"entity/enchanter_book");
    public static final Material BOOK_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BOOK_TEXTURE);
    private final BookModel model = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));

    public void render(SoulEnchanterTileEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f1;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 0.75, 0.5);
        float f = ClientInfo.getClientPartialTicks() / 5.0f;
        matrixStackIn.translate(0.0, (double)(0.1f + Mth.sin((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = tileEntityIn.nextPageAngle - tileEntityIn.pageAngle; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = tileEntityIn.pageAngle + f1 * partialTicks;
        matrixStackIn.mulPose(Axis.YP.rotation(-f2));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(80.0f));
        float f3 = Mth.lerp((float)partialTicks, (float)tileEntityIn.oFlip, (float)tileEntityIn.flip);
        float f4 = Mth.frac((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.frac((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.lerp((float)partialTicks, (float)tileEntityIn.pageTurningSpeed, (float)tileEntityIn.nextPageTurningSpeed);
        this.model.setupAnim(f, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer ivertexbuilder = BOOK_MATERIAL.buffer(bufferIn, RenderType::entitySolid);
        this.model.render(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, -1);
        matrixStackIn.popPose();
    }
}

