/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.ritual;

import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.util.ColorUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class PurifyRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/purify_ritual");

    public PurifyRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 163, 252, 255));
    }

    @Override
    public Ritual cloneRitual() {
        return new PurifyRitual();
    }

    @Override
    public Ritual.RitualResult start(Level level, BlockPos pos) {
        List purifiable = level.getEntitiesOfClass(PathfinderMob.class, Ritual.getDefaultBounds(pos), entity -> entity instanceof ZombieVillager || entity instanceof ZombifiedPiglin || entity instanceof Zoglin);
        if (!purifiable.isEmpty() && !level.isClientSide) {
            level.playSound(null, pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (PathfinderMob entity2 : purifiable) {
                if (entity2 instanceof ZombieVillager) {
                    ZombieVillager villager = (ZombieVillager)entity2;
                    villager.finishConversion(world);
                }
                if (entity2 instanceof ZombifiedPiglin) {
                    entity2.remove(Entity.RemovalReason.KILLED);
                    Piglin piglin = new Piglin(EntityType.PIGLIN, (Level)world);
                    piglin.copyPosition((Entity)entity2);
                    piglin.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
                    world.addFreshEntity((Entity)piglin);
                }
                if (!(entity2 instanceof Zoglin)) continue;
                entity2.remove(Entity.RemovalReason.KILLED);
                Hoglin hoglin = new Hoglin(EntityType.HOGLIN, (Level)world);
                hoglin.copyPosition((Entity)entity2);
                hoglin.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
                world.addFreshEntity((Entity)hoglin);
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

