/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class EidolonAbstractTreeFeature
extends Feature<TreeConfiguration> {
    private static final ResourceLocation ILLWOOD_TREE1 = ResourceLocation.parse((String)"eidolon_repraised:illwood_tree1");
    private static final ResourceLocation ILLWOOD_TREE2 = ResourceLocation.parse((String)"eidolon_repraised:illwood_tree2");
    private static final ResourceLocation ILLWOOD_TREE3 = ResourceLocation.parse((String)"eidolon_repraised:illwood_tree3");
    private static final ResourceLocation[] ILLWOOD_TREE = new ResourceLocation[]{ILLWOOD_TREE1, ILLWOOD_TREE2, ILLWOOD_TREE3};

    public EidolonAbstractTreeFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    public static boolean isAirOrLeavesAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.LEAVES));
    }

    public static boolean isAirOrLeavesOrLogsAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.LEAVES) || state.is(BlockTags.LOGS));
    }

    private static boolean isDirtOrFarmlandAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> {
            Block block = state.getBlock();
            return EidolonAbstractTreeFeature.isDirt((BlockState)state) || block == Blocks.FARMLAND;
        });
    }

    public boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel reader = context.level();
        TreeConfiguration config = (TreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        int i = rand.nextInt(ILLWOOD_TREE.length);
        if (!EidolonAbstractTreeFeature.isDirtOrFarmlandAt((LevelSimulatedReader)reader, pos.below())) {
            return false;
        }
        for (int j = 0; j < 8; ++j) {
            BlockPos upPos = new BlockPos((Vec3i)pos).above();
            for (int k = 0; k < j; ++k) {
                upPos = upPos.above();
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos)) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.north())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.south())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.east())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.east().north())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.east().south())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.west())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.west().north())) {
                return false;
            }
            if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.west().south())) continue;
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.below().north())) {
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.below().south())) {
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.below().east())) {
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.below().west())) {
            return false;
        }
        BlockRotProcessor BlockRotProcessor2 = new BlockRotProcessor(0.9f);
        StructureTemplateManager templatemanager = reader.getLevel().getServer().getStructureManager();
        StructureTemplate template = templatemanager.getOrCreate(ILLWOOD_TREE[i]);
        Rotation rotation = Rotation.getRandom((RandomSource)rand);
        BlockPos halfLengths = new BlockPos(template.getSize().getX() / 2, template.getSize().getY() / 2, template.getSize().getZ() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setRotation(rotation).setRotationPivot(halfLengths).setIgnoreEntities(false);
        BlockPos.MutableBlockPos pos1 = mutable.set((Vec3i)pos).move(-halfLengths.getX(), 0, -halfLengths.getZ());
        template.placeInWorld((ServerLevelAccessor)reader, (BlockPos)pos1, (BlockPos)pos1, placementsettings, rand, 2);
        return true;
    }
}

