/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.potion;

import alexthw.eidolon_repraised.registries.EidolonPotions;
import alexthw.eidolon_repraised.util.ColorUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMobEffectExtension;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class AnchoredEffect
extends MobEffect
implements IMobEffectExtension {
    protected static final ResourceLocation EFFECT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/mob_effect/anchored.png");

    public AnchoredEffect() {
        super(MobEffectCategory.BENEFICIAL, ColorUtil.packColor(255, 154, 58, 232));
        NeoForge.EVENT_BUS.addListener(this::anchor);
    }

    @SubscribeEvent
    public void anchor(EntityTeleportEvent event) {
        LivingEntity living;
        if (event instanceof EntityTeleportEvent.TeleportCommand) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(EidolonPotions.ANCHORED_EFFECT)) {
            event.setCanceled(true);
        }
    }
}

