/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.capability;

import alexthw.eidolon_repraised.capability.PatronManaImpl;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.SoulUpdatePacket;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public interface IMana {
    public static void expendMana(Player player, int amount) {
        if (player.isCreative()) {
            return;
        }
        PatronManaImpl mana = (PatronManaImpl)player.getCapability(EidolonCapabilities.MANA_CAPABILITY);
        if (mana == null) {
            return;
        }
        if (mana.getMagic() >= (float)amount) {
            mana.takeMagic(amount);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Networking.sendToPlayerClient(new SoulUpdatePacket(player), serverPlayer);
            }
        }
    }

    public boolean hasMagic();

    public float getMaxMagic();

    public float getMagic();

    public void setMagic(float var1);

    public void setMaxMagic(float var1);

    default public void takeMagic(float amount) {
        amount = Math.max(0.0f, amount);
        this.setMagic(this.getMagic() - amount);
    }

    default public void giveMagic(float amount) {
        amount = Math.max(0.0f, amount);
        this.setMagic(this.getMagic() + amount);
    }
}

