/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui.jei;

import alexthw.eidolon_repraised.gui.jei.JEIRegistry;
import alexthw.eidolon_repraised.recipe.WorktableRecipe;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class WorktableCategory
implements IRecipeCategory<WorktableRecipe> {
    static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"worktable");
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_worktable_page.png");

    public WorktableCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/jei_page_bg.png"), 0, 0, 138, 172);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Registry.WORKTABLE.get()));
    }

    @NotNull
    public RecipeType<WorktableRecipe> getRecipeType() {
        return JEIRegistry.WORKTABLE_CATEGORY;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)I18n.get((String)"jei.eidolon_repraised.worktable", (Object[])new Object[0]));
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder layout, @NotNull WorktableRecipe recipe, @NotNull IFocusGroup ingredients) {
        List<Ingredient> inputs = recipe.getCore();
        List<Ingredient> outers = recipe.getOuter();
        for (int i = 0; i < 3; ++i) {
            int index;
            for (int j = 0; j < 3 && (index = i * 3 + j) < inputs.size(); ++j) {
                Ingredient input = inputs.get(index);
                if (input == null) continue;
                layout.addSlot(RecipeIngredientRole.INPUT, 44 + j * 17, 37 + i * 17).addIngredients(input);
            }
        }
        layout.addSlot(RecipeIngredientRole.INPUT, 61, 15).addIngredients(outers.get(0));
        layout.addSlot(RecipeIngredientRole.INPUT, 100, 54).addIngredients(outers.get(1));
        layout.addSlot(RecipeIngredientRole.INPUT, 61, 93).addIngredients(outers.get(2));
        layout.addSlot(RecipeIngredientRole.INPUT, 22, 54).addIngredients(outers.get(3));
        layout.addSlot(RecipeIngredientRole.OUTPUT, 61, 133).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }

    public void draw(@NotNull WorktableRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics mStack, double mouseX, double mouseY) {
        mStack.blit(BACKGROUND, 5, 4, 0, 0, 128, 160);
    }
}

