/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item.model;

import alexthw.eidolon_repraised.common.item.model.ArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class WarlockArmorModel
extends ArmorModel {
    public WarlockArmorModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition root = WarlockArmorModel.createHumanoidAlias(mesh);
        PartDefinition body = root.getChild("body");
        PartDefinition right_foot = root.getChild("right_foot");
        PartDefinition left_foot = root.getChild("left_foot");
        PartDefinition left_arm = root.getChild("left_arm");
        PartDefinition right_arm = root.getChild("right_arm");
        PartDefinition head = root.getChild("head");
        PartDefinition left_boot = left_foot.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(0, 84).addBox(-2.5f, 5.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 80).addBox(-2.5f, 9.5f, -3.5f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition left_boot_cuff = left_boot.addOrReplaceChild("left_boot_cuff", CubeListBuilder.create().texOffs(20, 84).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition right_boot = right_foot.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(0, 84).addBox(-2.5f, 5.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 80).addBox(-2.5f, 9.5f, -3.5f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition right_boot_cuff = right_boot.addOrReplaceChild("right_boot_cuff", CubeListBuilder.create().texOffs(20, 84).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition right_sleeve = right_arm.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(28, 38).addBox(-4.5f, -2.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition right_cuff = right_sleeve.addOrReplaceChild("right_cuff", CubeListBuilder.create().texOffs(28, 48).addBox(-4.5f, -0.5f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0873f));
        PartDefinition left_sleeve = left_arm.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(28, 38).mirror().addBox(-0.5f, -2.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition left_cuff = left_sleeve.addOrReplaceChild("left_cuff", CubeListBuilder.create().texOffs(28, 48).mirror().addBox(-1.5f, -0.5f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.0873f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -1.0f, -7.0f, 14.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)-0.0873f));
        PartDefinition hatMid = hat.addOrReplaceChild("hatMid", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, -5.75f, -4.5f, 9.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0873f));
        PartDefinition hatUpper = hatMid.addOrReplaceChild("hatUpper", CubeListBuilder.create().texOffs(0, 31).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0436f));
        PartDefinition hatTip = hatUpper.addOrReplaceChild("hatTip", CubeListBuilder.create().texOffs(24, 31).addBox(-1.5f, -4.5f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0873f));
        PartDefinition cloak = body.addOrReplaceChild("cloak", CubeListBuilder.create().texOffs(0, 41).addBox(-6.5f, -12.4f, -2.5f, 9.0f, 15.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(28, 56).addBox(-7.0f, -12.5f, -3.0f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_side = cloak.addOrReplaceChild("left_side", CubeListBuilder.create().texOffs(0, 64).addBox(-2.0f, 0.0f, 0.01f, 2.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-4.5f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition right_side = cloak.addOrReplaceChild("right_side", CubeListBuilder.create().texOffs(0, 64).addBox(0.0f, 0.0f, 0.01f, 2.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-4.5f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition back_side = cloak.addOrReplaceChild("back_side", CubeListBuilder.create().texOffs(17, 70).addBox(-5.01f, 0.0f, 0.0f, 10.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-4.5f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)128);
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        if (entity.getFallFlyingTicks() > 4) {
            f = (float)entity.getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (this.slot == EquipmentSlot.CHEST) {
            this.body.getChild((String)"cloak").getChild((String)"back_side").xRot = 0.1745f + Mth.abs((float)(Mth.cos((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
            this.body.getChild((String)"cloak").getChild((String)"left_side").zRot = 0.1745f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.2f * limbSwingAmount / f + 0.1f * limbSwingAmount / f;
            this.body.getChild((String)"cloak").getChild((String)"right_side").zRot = -0.1745f - Mth.cos((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount / f - 0.1f * limbSwingAmount / f;
        }
    }
}

