/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.common.item.model.BonelordArmorModel;
import alexthw.eidolon_repraised.registries.EidolonMaterials;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.extensions.IItemExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BonelordArmorItem
extends ArmorItem
implements IItemExtension {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};

    public BonelordArmorItem(ArmorItem.Type slot, Item.Properties builderIn) {
        super(EidolonMaterials.BONELORD, slot, builderIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public BonelordArmorModel getHumanoidArmorModel(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, @NotNull EquipmentSlot armorSlot, @NotNull HumanoidModel _default) {
                float pticks = Minecraft.getInstance().getFrameTimeNs();
                float f = Mth.rotLerp((float)pticks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
                float f1 = Mth.rotLerp((float)pticks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.lerp((float)pticks, (float)entity.xRotO, (float)entity.getXRot());
                ClientRegistry.BONELORD_ARMOR_MODEL.slot = BonelordArmorItem.this.getEquipmentSlot();
                ClientRegistry.BONELORD_ARMOR_MODEL.copyFromDefault(_default);
                ClientRegistry.BONELORD_ARMOR_MODEL.setupAnim(entity, entity.walkAnimation.position(), entity.walkAnimation.speed(), (float)entity.tickCount + pticks, netHeadYaw, netHeadPitch);
                return ClientRegistry.BONELORD_ARMOR_MODEL;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/entity/bonelord_armor.png");
    }
}

