/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.entity.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class GenericBarterGoal<E extends PathfinderMob>
extends Goal {
    static final Random rand = new Random();
    final Predicate<ItemStack> valid;
    final Function<ItemStack, ItemStack> result;
    int progress = 0;
    int cooldown = 0;
    int lastTick = 0;
    final E entity;
    ItemStack backupHack = ItemStack.EMPTY;

    public GenericBarterGoal(E entity, Predicate<ItemStack> valid, Function<ItemStack, ItemStack> result) {
        this.entity = entity;
        this.valid = valid;
        this.result = result;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        if (this.cooldown > 0) {
            return;
        }
        if (this.progress > 0 && !this.backupHack.isEmpty()) {
            this.entity.setItemInHand(InteractionHand.MAIN_HAND, this.backupHack);
        }
        this.entity.setTarget(null);
        if (this.progress > 0) {
            --this.progress;
            this.entity.getNavigation().stop();
            if (this.progress == 0) {
                if (!this.entity.level().isClientSide) {
                    this.entity.level().addFreshEntity((Entity)new ItemEntity(this.entity.level(), this.entity.getX(), this.entity.getY() + 0.1, this.entity.getZ(), this.result.apply(this.entity.getMainHandItem().copy())));
                }
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                this.cooldown = 600;
            }
        } else {
            List items = this.entity.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.entity.blockPosition().offset(-8, -8, -8).getBottomCenter(), this.entity.blockPosition().offset(8, 8, 8).getCenter()), item -> this.valid.test(item.getItem()));
            ItemEntity nearest = items.stream().min(Comparator.comparingDouble(a -> a.distanceToSqr(this.entity))).get();
            if (nearest.distanceToSqr(this.entity) < 2.25) {
                this.progress = 100;
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, nearest.getItem());
                nearest.remove(Entity.RemovalReason.DISCARDED);
                this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.HOSTILE, 0.2f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            this.entity.getNavigation().moveTo(nearest.getX(), nearest.getY(), nearest.getZ(), 1.0);
        }
        if (!this.entity.getMainHandItem().isEmpty()) {
            this.backupHack = this.entity.getMainHandItem();
        }
    }

    public boolean canUse() {
        if (--this.cooldown > 0) {
            return false;
        }
        if (this.progress > 0 || ((PathfinderMob)this.entity).tickCount < this.lastTick + 20) {
            return false;
        }
        this.lastTick = ((PathfinderMob)this.entity).tickCount;
        List items = this.entity.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.entity.blockPosition().offset(-8, -8, -8).getBottomCenter(), this.entity.blockPosition().offset(8, 8, 8).getCenter()), item -> this.valid.test(item.getItem()));
        return !items.isEmpty();
    }

    public boolean canContinueToUse() {
        if (this.progress > 0) {
            return true;
        }
        List items = this.entity.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.entity.blockPosition().offset(-8, -8, -8).getBottomCenter(), this.entity.blockPosition().offset(8, 8, 8).getCenter()), item -> this.valid.test(item.getItem()));
        return !items.isEmpty();
    }
}

