/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.common.tile.IBurner;
import alexthw.eidolon_repraised.network.IgniteEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.registries.Researches;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FireTouchSpell
extends StaticSpell {
    public FireTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, 10, 5, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos blockPos, Player player) {
        if (!KnowledgeUtil.knowsResearch(player, Researches.FIRE_SPELL.getRegistryName())) {
            return false;
        }
        HitResult ray = FireTouchSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (ray instanceof BlockHitResult) {
            BlockHitResult rayTraceResult = (BlockHitResult)ray;
            BlockState hitState = world.getBlockState(rayTraceResult.getBlockPos());
            if (hitState.getBlock() instanceof CandleBlock && CandleBlock.canLight((BlockState)hitState) || hitState.getBlock() instanceof CampfireBlock && CampfireBlock.canLight((BlockState)hitState)) {
                return true;
            }
            BlockEntity blockEntity = world.getBlockEntity(rayTraceResult.getBlockPos());
            if (blockEntity instanceof IBurner) {
                IBurner brazier = (IBurner)blockEntity;
                return brazier.canStartBurning();
            }
        }
        return ray instanceof EntityHitResult;
    }

    @Override
    public void cast(Level world, BlockPos blockPos, Player player) {
        if (!world.isClientSide) {
            HitResult ray = FireTouchSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
            if (ray instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)ray;
                BlockState hitState = world.getBlockState(blockHitResult.getBlockPos());
                if (hitState.getBlock() instanceof CandleBlock && CandleBlock.canLight((BlockState)hitState) || hitState.getBlock() instanceof CampfireBlock && CampfireBlock.canLight((BlockState)hitState)) {
                    world.setBlock(blockHitResult.getBlockPos(), (BlockState)hitState.setValue((Property)AbstractCandleBlock.LIT, (Comparable)Boolean.TRUE), 11);
                    Networking.sendToNearbyClient(world, blockHitResult.getBlockPos(), (CustomPacketPayload)new IgniteEffectPacket(blockHitResult.getBlockPos(), 1.0f, 0.5f, 0.25f));
                } else {
                    BlockEntity blockEntity = world.getBlockEntity(blockHitResult.getBlockPos());
                    if (blockEntity instanceof IBurner) {
                        IBurner brazier = (IBurner)blockEntity;
                        brazier.startBurning(player, world, blockHitResult.getBlockPos());
                    }
                }
                world.playSound(player, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.4f + 0.8f);
            } else if (ray instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)ray;
                entityHitResult.getEntity().setRemainingFireTicks(200);
            } else {
                return;
            }
            IMana.expendMana(player, this.getCost());
        }
    }
}

