/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.api.research.Research;
import alexthw.eidolon_repraised.common.item.ItemBase;
import alexthw.eidolon_repraised.common.item.ResearchNotesItem;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Researches;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import java.util.Collection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class NotetakingToolsItem
extends ItemBase {
    public NotetakingToolsItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        Collection<Research> researches = Researches.getEntityResearches((Entity)entity);
        if (!researches.isEmpty()) {
            Research r = researches.iterator().next();
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (r != null) {
                    ItemStack notes = new ItemStack((ItemLike)Registry.RESEARCH_NOTES.get(), 1);
                    notes.set(EidolonDataComponents.RESEARCH, (Object)new ResearchNotesItem.ResearchData(r.getRegistryName(), 0, 1418644859L + 978060631L * serverLevel.getSeed()));
                    stack.shrink(1);
                    if (stack.getCount() == 0) {
                        player.setItemInHand(hand, notes);
                    } else if (!player.getInventory().add(notes)) {
                        player.drop(notes, false);
                    }
                }
            }
            return InteractionResult.PASS;
        }
        return super.interactLivingEntity(stack, player, entity, hand);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        Collection<Research> researches = Researches.getBlockResearches(state.getBlock());
        researches.removeIf(r -> KnowledgeUtil.knowsResearch(ctx.getPlayer(), r.getRegistryName()));
        if (!researches.isEmpty()) {
            Research r2 = researches.iterator().next();
            ItemStack notes = new ItemStack((ItemLike)Registry.RESEARCH_NOTES.get(), 1);
            notes.set(EidolonDataComponents.RESEARCH, (Object)new ResearchNotesItem.ResearchData(r2.getRegistryName(), 0, 1418644859L));
            ctx.getItemInHand().shrink(1);
            if (ctx.getItemInHand().getCount() == 0) {
                ctx.getPlayer().setItemInHand(ctx.getHand(), ItemStack.EMPTY);
            }
            if (!ctx.getPlayer().getInventory().add(notes.copy())) {
                ctx.getPlayer().drop(notes, false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }
}

