/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WorktableRecipe
implements Recipe<CraftingInput> {
    final List<Ingredient> core;
    final List<Ingredient> extras;
    final ItemStack result;
    ResourceLocation registryName;

    public WorktableRecipe(Ingredient[] core, Ingredient[] extras, ItemStack result) {
        this.core = List.of(core);
        this.extras = List.of(extras);
        this.result = result;
    }

    @Deprecated
    public WorktableRecipe(ItemStack[] inputs, ItemStack result) {
        Ingredient[] core = new Ingredient[9];
        Ingredient[] extras = new Ingredient[4];
        for (int i = 0; i < inputs.length; ++i) {
            if (i < 9) {
                core[i] = Ingredient.of((ItemStack[])new ItemStack[]{inputs[i]});
                continue;
            }
            extras[i - 9] = Ingredient.of((ItemStack[])new ItemStack[]{inputs[i]});
        }
        this.core = List.of(core);
        this.extras = List.of(extras);
        this.result = result;
    }

    public WorktableRecipe(List<Ingredient> core, List<Ingredient> outer, ItemStack itemStack) {
        this.core = core;
        this.extras = outer;
        this.result = itemStack;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public WorktableRecipe setRegistryName(String domain, String path) {
        this.registryName = ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
        return this;
    }

    public WorktableRecipe setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    public Ingredient[] getCoreA() {
        return this.core.toArray(new Ingredient[9]);
    }

    public Ingredient[] getOuterA() {
        return this.extras.toArray(new Ingredient[4]);
    }

    public List<Ingredient> getCore() {
        return this.core;
    }

    public List<Ingredient> getOuter() {
        return this.extras;
    }

    public boolean matches(Container coreInv, Container extraInv) {
        Ingredient ingredient;
        int i;
        if (coreInv.getContainerSize() < 9 || extraInv.getContainerSize() < 4 || this.core == null) {
            return false;
        }
        for (i = 0; i < this.core.size(); ++i) {
            ingredient = this.core.get(i);
            if (ingredient == null || ingredient.test(coreInv.getItem(i))) continue;
            return false;
        }
        for (i = 0; i < this.extras.size(); ++i) {
            ingredient = this.extras.get(i);
            if (ingredient == null || ingredient.test(extraInv.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(Container coreInv, Container extraInv) {
        NonNullList items = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        for (int i = 0; i < items.size(); ++i) {
            Container inv = i < 9 ? coreInv : extraInv;
            ItemStack item = inv.getItem(i < 9 ? i : i - 9);
            if (!item.hasCraftingRemainingItem()) continue;
            items.set(i, (Object)item.getCraftingRemainingItem());
        }
        return items;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.addAll(this.core);
        ingredients.addAll(this.extras);
        return ingredients;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.WORKTABLE_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.WORKTABLE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<WorktableRecipe> {
        public static final MapCodec<WorktableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("core").forGetter(r -> r.core), (App)Ingredient.CODEC.listOf().fieldOf("extras").forGetter(r -> r.extras), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)instance, WorktableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WorktableRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), WorktableRecipe::getCore, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), WorktableRecipe::getOuter, (StreamCodec)ItemStack.STREAM_CODEC, WorktableRecipe::getResult, WorktableRecipe::new);

        @NotNull
        public MapCodec<WorktableRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WorktableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

