/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.common.tile.CrucibleTileEntity;
import alexthw.eidolon_repraised.recipe.CrucibleRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CrucibleRegistry {
    static final Map<ResourceLocation, CrucibleRecipe> recipes = new HashMap<ResourceLocation, CrucibleRecipe>();

    public static CrucibleRecipe register(CrucibleRecipe recipe) {
        ResourceLocation loc = recipe.getRegistryName();
        assert (loc != null);
        recipes.put(loc, recipe);
        return recipe;
    }

    public static CrucibleRecipe find(ResourceLocation loc) {
        return recipes.get(loc);
    }

    public static CrucibleRecipe find(List<CrucibleTileEntity.CrucibleStep> steps) {
        for (CrucibleRecipe recipe : recipes.values()) {
            if (!recipe.matches(steps)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean doStepsHaveSomeResult(List<CrucibleTileEntity.CrucibleStep> steps) {
        for (CrucibleRecipe recipe : recipes.values()) {
            if (steps.size() > recipe.getSteps().size() || !CrucibleRegistry.doStepsMatch(steps, recipe.getSteps())) continue;
            return true;
        }
        return false;
    }

    private static boolean doStepsMatch(List<CrucibleTileEntity.CrucibleStep> steps, List<CrucibleRecipe.Step> otherSteps) {
        for (int i = 0; i < steps.size(); ++i) {
            CrucibleTileEntity.CrucibleStep step = steps.get(i);
            CrucibleRecipe.Step otherStep = otherSteps.get(i);
            if (step.getStirs() != otherStep.stirs()) {
                return false;
            }
            if (CrucibleRegistry.doContentsMatch(step, otherStep)) continue;
            return false;
        }
        return true;
    }

    private static boolean doContentsMatch(CrucibleTileEntity.CrucibleStep step, CrucibleRecipe.Step otherStep) {
        for (ItemStack input : step.getContents()) {
            boolean doesInputHaveMatch = false;
            for (Ingredient ingredient : otherStep.matches()) {
                if (!ingredient.test(input)) continue;
                doesInputHaveMatch = true;
                break;
            }
            if (doesInputHaveMatch) continue;
            return false;
        }
        return true;
    }

    public static void init() {
    }
}

