/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.recipe.WorktableRecipe;
import alexthw.eidolon_repraised.recipe.WorktableRegistry;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class WorktableResultSlot
extends Slot {
    private final CraftingContainer core;
    private final CraftingContainer extras;
    private final Player player;
    private int amountCrafted;

    public WorktableResultSlot(Player player, CraftingContainer core, CraftingContainer extras, Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
        this.player = player;
        this.core = core;
        this.extras = extras;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(@NotNull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int numItemsCrafted) {
        this.amountCrafted += numItemsCrafted;
    }

    protected void checkTakeAchievements(@NotNull ItemStack stack) {
        Container container;
        if (this.amountCrafted > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.amountCrafted);
            EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.core);
        }
        if ((container = this.container) instanceof ResultContainer) {
            ResultContainer resultContainer = (ResultContainer)container;
            resultContainer.awardUsedRecipes(this.player, Collections.singletonList(stack));
        }
        this.player.playSound(SoundEvents.SMITHING_TABLE_USE, 1.0f, 1.0f);
        this.amountCrafted = 0;
    }

    public void onTake(@NotNull Player thePlayer, @NotNull ItemStack stack) {
        this.checkTakeAchievements(stack);
        CommonHooks.setCraftingPlayer((Player)thePlayer);
        WorktableRecipe recipe = WorktableRegistry.find((Container)this.core, (Container)this.extras);
        NonNullList<ItemStack> items = null;
        if (recipe != null) {
            items = recipe.getRemainingItems((Container)this.core, (Container)this.extras);
        } else {
            items = NonNullList.create();
            items.addAll((Collection)thePlayer.level().getRecipeManager().getRemainingItemsFor(RecipeType.CRAFTING, (RecipeInput)this.core.asCraftInput(), thePlayer.level()));
            for (int i = 0; i < 4; ++i) {
                items.add((Object)this.extras.getItem(i));
            }
        }
        CommonHooks.setCraftingPlayer(null);
        assert (items != null);
        int n = recipe == null ? Math.min(9, items.size()) : items.size();
        for (int i = 0; i < n; ++i) {
            CraftingContainer inv = i < 9 ? this.core : this.extras;
            int index = i < 9 ? i : i - 9;
            ItemStack item = inv.getItem(index);
            ItemStack remaining = (ItemStack)items.get(i);
            if (!item.isEmpty()) {
                inv.removeItem(index, 1);
                item = inv.getItem(index);
            }
            if (remaining.isEmpty()) continue;
            if (item.isEmpty()) {
                inv.setItem(index, remaining);
                continue;
            }
            if (ItemStack.isSameItem((ItemStack)item, (ItemStack)remaining) && ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)remaining)) {
                remaining.grow(item.getCount());
                inv.setItem(index, remaining);
                continue;
            }
            if (this.player.getInventory().add(remaining)) continue;
            this.player.drop(remaining, false);
        }
    }
}

