/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ScriptoriumContainer
extends AbstractContainerMenu {
    private final Container inventory = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            ScriptoriumContainer.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess access;
    public List<Sign> signs;

    public ScriptoriumContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.NULL);
    }

    public ScriptoriumContainer(int id, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)Registry.SCRIPTORIUM_CONTAINER.get(), id);
        this.access = access;
        this.addSlot(new NotesSlot(this.inventory, 0, -30, 33));
        this.addSlot(new NotesSlot(this.inventory, 1, -30, 56));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 12 + i1 * 18, 130 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 12 + l * 18, 188));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 0 || index > 1 && index < 38) {
                if (((Slot)this.slots.getFirst()).mayPlace(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : (index >= 29 ? !this.moveItemStackTo(itemstack1, 2, 29, false) : !this.moveItemStackTo(itemstack1, 2, 38, false)))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(itemstack1, 2, 38, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return ScriptoriumContainer.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)Registry.SCRIPTORIUM.get()));
    }

    public void removed(@NotNull Player pPlayer) {
        super.removed(pPlayer);
        for (Slot slot : this.slots) {
            ItemStack stack;
            if (!(slot instanceof NotesSlot) || (stack = slot.getItem()).isEmpty()) continue;
            pPlayer.drop(stack, false);
            slot.set(ItemStack.EMPTY);
        }
    }

    public void setChant(List<Sign> currentChant) {
        if (currentChant.isEmpty()) {
            return;
        }
        this.access.execute((p_217003_6_, p_217003_7_) -> {
            ItemStack stack2 = ((Slot)this.slots.get(1)).getItem().copy();
            if (stack2.isEmpty() || stack2.getCount() < stack2.getMaxStackSize() && ((List)stack2.getOrDefault(EidolonDataComponents.SPELL, List.of())).equals(currentChant)) {
                ((Slot)this.slots.getFirst()).remove(1);
                ItemStack stack = ((Item)Registry.CHANT_SCROLL.get()).getDefaultInstance();
                if (stack2.isEmpty()) {
                    stack.set(EidolonDataComponents.SPELL, (Object)currentChant);
                    stack2 = stack;
                } else {
                    stack2.grow(1);
                }
                ((Slot)this.slots.get(1)).set(stack2);
                this.inventory.setChanged();
                this.slotsChanged(this.inventory);
            }
        });
    }

    static class NotesSlot
    extends Slot {
        public NotesSlot(Container iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is((Item)Registry.CHANT_SCROLL.get());
        }
    }
}

