/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.api.research.ResearchTask;
import alexthw.eidolon_repraised.common.item.ResearchNotesItem;
import alexthw.eidolon_repraised.common.tile.TileEntityBase;
import alexthw.eidolon_repraised.gui.ResearchTableContainer;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ResearchTableTileEntity
extends TileEntityBase
implements WorldlyContainer,
MenuProvider {
    private static final int[] SLOTS = new int[]{0, 1};
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ResearchTask> tasks = NonNullList.create();
    private Component name;
    private int progress = 0;
    private int worldSeed;
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    public static final int SEED = 1418644859;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ResearchTableTileEntity.this.progress;
                case 1 -> ResearchTableTileEntity.this.worldSeed;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ResearchTableTileEntity.this.progress = value;
                    break;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public ResearchTableTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.RESEARCH_TABLE_TILE_ENTITY.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.worldSeed = 1418644859 + 978060631 * (int)((ServerLevel)this.level).getSeed();
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.eidolon_repraised.research_table");
    }

    public void addListener(ContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)stack);
        }
    }

    public void tick() {
        if (this.progress < 0) {
            this.progress = 0;
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
        if (this.progress > 0) {
            if (((ItemStack)this.stacks.getFirst()).isEmpty() || ((ItemStack)this.stacks.getFirst()).getItem() != Registry.RESEARCH_NOTES.get()) {
                this.progress = 0;
                this.sync((HolderLookup.Provider)this.level.registryAccess());
                for (ContainerListener listener : this.listeners) {
                    listener.dataChanged((AbstractContainerMenu)listener, 0, this.progress);
                }
                return;
            }
            --this.progress;
            if (this.progress == 0) {
                ItemStack notes = (ItemStack)this.stacks.getFirst();
                ResearchNotesItem.ResearchData notesTag = (ResearchNotesItem.ResearchData)notes.get(EidolonDataComponents.RESEARCH);
                notes.set(EidolonDataComponents.RESEARCH, (Object)new ResearchNotesItem.ResearchData(notesTag.research(), notesTag.stepsDone() + 1));
                for (ContainerListener listener : this.listeners) {
                    listener.slotChanged((AbstractContainerMenu)listener, 0, (ItemStack)this.stacks.getFirst());
                }
            }
            this.sync((HolderLookup.Provider)this.level.registryAccess());
            for (ContainerListener listener : this.listeners) {
                listener.dataChanged((AbstractContainerMenu)listener, 0, this.progress);
            }
        }
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.stacks, (HolderLookup.Provider)provider);
        this.progress = nbt.getInt("progress");
        this.worldSeed = nbt.getInt("worldSeed");
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("progress", this.progress);
        compound.putInt("worldSeed", this.worldSeed);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)provider);
    }

    @NotNull
    public ItemStack getItem(int index) {
        return index >= 0 && index < this.stacks.size() ? (ItemStack)this.stacks.get(index) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.stacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.stacks, (int)index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.stacks.size()) {
            this.stacks.set(index, (Object)stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        if (player.level().getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        if (index == 0) {
            return stack.is((Item)Registry.RESEARCH_NOTES.get());
        }
        if (index == 1) {
            return stack.is((Item)Registry.ARCANE_SEAL.get());
        }
        return false;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (index == 0) {
            return stack.is((Item)Registry.COMPLETED_RESEARCH.get());
        }
        return false;
    }

    public void clearContent() {
        this.stacks.clear();
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ResearchTableContainer(id, inv, (Container)this, this.dataAccess);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"");
    }
}

