/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.common.tile.TileEntityBase;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.util.RegistryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GobletTileEntity
extends TileEntityBase {
    EntityType<?> type = null;

    public GobletTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.GOBLET_TILE_ENTITY.get(), pos, state);
    }

    public EntityType<?> getEntityType() {
        return this.type;
    }

    public void setEntityType(EntityType<?> type) {
        this.type = type;
        this.sync((HolderLookup.Provider)this.level.registryAccess());
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.type = tag.contains("type") ? (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)tag.getString("type"))) : null;
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        if (this.type != null) {
            tag.putString("type", RegistryUtil.getRegistryName(this.type).toString());
        }
    }
}

