/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.Config;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.common.tile.TileEntityBase;
import alexthw.eidolon_repraised.network.CrucibleFailPacket;
import alexthw.eidolon_repraised.network.CrucibleSuccessPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.recipe.CrucibleRecipe;
import alexthw.eidolon_repraised.recipe.CrucibleRegistry;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class CrucibleTileEntity
extends TileEntityBase {
    boolean boiling = false;
    public boolean hasWater = false;
    int stirTicks = 0;
    int stirs = 0;
    int stepCounter = 0;
    final List<CrucibleStep> steps = new ArrayList<CrucibleStep>();
    long seed = 0L;
    final Random random = new Random();
    public FluidTank tank = new FluidTank(1000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().isSame((Fluid)Fluids.WATER);
        }

        public void onContentsChanged() {
            super.onContentsChanged();
            if (CrucibleTileEntity.this.level != null) {
                boolean bl = CrucibleTileEntity.this.hasWater = this.getFluid().getAmount() == 1000;
                if (!((CrucibleTileEntity)CrucibleTileEntity.this).level.isClientSide) {
                    CrucibleTileEntity.this.sync((HolderLookup.Provider)CrucibleTileEntity.this.level.registryAccess());
                }
            }
        }
    };
    public static final List<Predicate<BlockState>> HOT_BLOCKS = new ArrayList<Predicate<BlockState>>(List.of(b -> b.is(Registry.CRUCIBLE_HOT_BLOCKS), b -> b.getBlock() instanceof CampfireBlock && b.hasProperty((Property)CampfireBlock.LIT) && (Boolean)b.getValue((Property)CampfireBlock.LIT) != false));

    public float getRed() {
        this.random.setSeed(this.seed);
        return this.random.nextFloat();
    }

    public float getGreen() {
        this.random.setSeed(this.seed * 2L);
        return this.random.nextFloat();
    }

    public float getBlue() {
        this.random.setSeed(this.seed * 3L);
        return this.random.nextFloat();
    }

    public void fill() {
        this.tank.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
    }

    private void drain() {
        this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
    }

    public CrucibleTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.CRUCIBLE_TILE_ENTITY.get(), pos, state);
    }

    public CrucibleTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player) {
        InteractionHand hand = player.getUsedItemHand();
        if (this.level != null) {
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
                return InteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty() && this.hasWater) {
                this.boiling = false;
                this.stirs = 0;
                this.steps.clear();
                if (!this.level.isClientSide) {
                    this.drain();
                    this.level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(hand).isEmpty() && this.stirTicks == 0 && !this.steps.isEmpty()) {
                ++this.stirs;
                this.stirTicks = 20;
                if (!this.level.isClientSide) {
                    this.level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.steps.clear();
        ListTag steps = tag.getList("steps", 10);
        for (Tag step : steps) {
            this.steps.add(new CrucibleStep((CompoundTag)step, provider));
        }
        this.boiling = tag.getBoolean("boiling");
        this.tank.readFromNBT(provider, tag);
        this.hasWater = this.tank.getFluidAmount() == 1000;
        this.stirs = tag.getInt("stirs");
        this.stirTicks = tag.getInt("stirTicks");
        this.seed = steps.stream().map(Object::hashCode).reduce(0, (a, b) -> a ^ b).intValue();
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag steps = new ListTag();
        for (CrucibleStep step : this.steps) {
            steps.add((Object)step.write(provider));
        }
        tag.put("steps", (Tag)steps);
        tag.putBoolean("boiling", this.boiling);
        tag.putInt("stirs", this.stirs);
        tag.putInt("stirTicks", this.stirTicks);
        if (!this.tank.isEmpty()) {
            this.tank.writeToNBT(provider, tag);
        }
    }

    public void tick() {
        List items;
        float steamB;
        boolean stepSize;
        if (this.stirTicks > 0) {
            --this.stirTicks;
        }
        if (this.level == null) {
            return;
        }
        if (this.hasWater && this.level.getGameTime() % 200L == 0L) {
            BlockState state = this.level.getBlockState(this.worldPosition.below());
            boolean isHeated = false;
            for (Predicate<BlockState> pred : HOT_BLOCKS) {
                if (!pred.test(state)) continue;
                isHeated = true;
                break;
            }
            if (this.boiling && !isHeated) {
                this.boiling = false;
                if (!this.level.isClientSide) {
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
            } else if (!this.boiling && isHeated) {
                this.boiling = true;
                if (!this.level.isClientSide) {
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
            }
        }
        float bubbleR = !(stepSize = this.steps.isEmpty()) ? Math.min(1.0f, this.getRed() * 1.25f) : 0.25f;
        float bubbleG = !stepSize ? Math.min(1.0f, this.getGreen() * 1.25f) : 0.5f;
        float bubbleB = !stepSize ? Math.min(1.0f, this.getBlue() * 1.25f) : 1.0f;
        float steamR = !stepSize ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getRed(), 2.0)) : 1.0f;
        float steamG = !stepSize ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getGreen(), 2.0)) : 1.0f;
        float f = steamB = !stepSize ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getBlue(), 2.0)) : 1.0f;
        if (this.level.isClientSide && this.hasWater && this.boiling) {
            for (int i = 0; i < 2; ++i) {
                Particles.create((ParticleType)EidolonParticles.BUBBLE_PARTICLE.get()).setScale(0.05f).setLifetime(10).addVelocity(0.0, 0.015625, 0.0).setColor(bubbleR, bubbleG, bubbleB).setAlpha(1.0f, 0.75f).spawn(this.level, (double)this.worldPosition.getX() + 0.125 + 0.75 * (double)this.level.random.nextFloat(), (double)this.worldPosition.getY() + 0.6875, (double)this.worldPosition.getZ() + 0.125 + 0.75 * (double)this.level.random.nextFloat());
                if (this.level.random.nextInt(8) != 0) continue;
                Particles.create((ParticleType)EidolonParticles.STEAM_PARTICLE.get()).setAlpha(0.0625f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset(0.375, 0.125).randomVelocity(0.0125f, 0.025f).addVelocity(0.0, 0.05f, 0.0).setColor(steamR, steamG, steamB).spawn(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.625, (double)this.worldPosition.getZ() + 0.5);
            }
        }
        if (!this.level.isClientSide && this.boiling && this.hasWater && this.level.getGameTime() % 8L == 0L) {
            List items2 = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).deflate(0.125));
            for (ItemEntity item : items2) {
                item.setPickUpDelay(20);
            }
        }
        if (!this.level.isClientSide && this.stepCounter > 0 && --this.stepCounter == 0) {
            if (((Boolean)Config.TURN_BASED_CRUCIBLE.get()).booleanValue()) {
                this.handleTurnBasedUpdate(steamR, steamG, steamB);
            } else {
                this.handleTimedUpdate(steamR, steamG, steamB);
            }
        }
        if (this.stepCounter == 0 && (stepSize || ((Boolean)Config.TURN_BASED_CRUCIBLE.get()).booleanValue()) && this.hasWater && this.boiling && this.level.getGameTime() % 100L == 0L && !(items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).deflate(0.125))).isEmpty()) {
            this.stepCounter = (Integer)Config.CRUCIBLE_STEP_DURATION.get() / 2;
        }
    }

    private void handleTurnBasedUpdate(float steamR, float steamG, float steamB) {
        List<ItemStack> contents = this.tryConsumeItems();
        if (this.stirs == 0 && contents.isEmpty()) {
            this.stepCounter = (Integer)Config.CRUCIBLE_STEP_BACKOFF.get();
            return;
        }
        CrucibleStep step = new CrucibleStep(this.stirs, contents);
        this.stirs = 0;
        if (!CrucibleRegistry.doStepsHaveSomeResult(this.steps)) {
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new CrucibleFailPacket(this.worldPosition));
            this.steps.clear();
            this.boiling = false;
            this.drain();
            return;
        }
        this.steps.add(step);
        CrucibleRecipe recipe = CrucibleRegistry.find(this.steps);
        if (recipe != null) {
            this.completeCraft(steamR, steamG, steamB, contents, recipe);
        } else {
            this.level.playSound(null, this.worldPosition, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.stepCounter = (Integer)Config.CRUCIBLE_STEP_DURATION.get();
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
    }

    private List<ItemStack> tryConsumeItems() {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).deflate(0.125));
        for (ItemEntity item : items) {
            for (int i = 0; i < item.getItem().getCount(); ++i) {
                ItemStack stack = item.getItem().copy();
                stack.setCount(1);
                contents.add(stack);
            }
            item.remove(Entity.RemovalReason.DISCARDED);
        }
        return contents;
    }

    private void handleTimedUpdate(float steamR, float steamG, float steamB) {
        List<ItemStack> contents = this.tryConsumeItems();
        if (this.stirs == 0 && contents.isEmpty()) {
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new CrucibleFailPacket(this.worldPosition));
            this.steps.clear();
            this.stirs = 0;
            this.boiling = false;
            this.drain();
        } else {
            CrucibleStep step = new CrucibleStep(this.stirs, contents);
            this.steps.add(step);
            this.stirs = 0;
            CrucibleRecipe recipe = CrucibleRegistry.find(this.steps);
            if (recipe != null) {
                this.completeCraft(steamR, steamG, steamB, contents, recipe);
            } else {
                this.level.playSound(null, this.worldPosition, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.stepCounter = (Integer)Config.CRUCIBLE_STEP_DURATION.get();
                this.sync((HolderLookup.Provider)this.level.registryAccess());
            }
        }
    }

    private void completeCraft(float steamR, float steamG, float steamB, List<ItemStack> contents, CrucibleRecipe recipe) {
        Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new CrucibleSuccessPacket(this.worldPosition, steamR, steamG, steamB));
        double angle = this.level.random.nextDouble() * Math.PI * 2.0;
        ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.75, (double)this.worldPosition.getZ() + 0.5, recipe.getResult().copy());
        entity.setDeltaMovement(Math.sin(angle) * 0.125, 0.25, Math.cos(angle) * 0.125);
        entity.setPickUpDelay(10);
        this.level.addFreshEntity((Entity)entity);
        contents.clear();
        this.steps.clear();
        this.boiling = false;
        this.drain();
    }

    public static class CrucibleStep {
        final int stirs;
        final List<ItemStack> contents = new ArrayList<ItemStack>();

        public CrucibleStep(int stirs, List<ItemStack> contents) {
            this.stirs = stirs;
            this.contents.addAll(contents);
        }

        public int getStirs() {
            return this.stirs;
        }

        public List<ItemStack> getContents() {
            return this.contents;
        }

        public CrucibleStep(CompoundTag nbt, HolderLookup.Provider provider) {
            this.stirs = nbt.getInt("stirs");
            ListTag list = nbt.getList("contents", 10);
            for (Tag item : list) {
                this.contents.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)item)));
            }
        }

        public CompoundTag write(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("stirs", this.stirs);
            ListTag list = new ListTag();
            for (ItemStack stack : this.contents) {
                list.add((Object)stack.save(provider, (Tag)new CompoundTag()));
            }
            nbt.put("contents", (Tag)list);
            return nbt;
        }
    }
}

