/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.spell.DarkTouchSpell;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class LightTouchSpell
extends DarkTouchSpell {
    public LightTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, signs);
        NeoForge.EVENT_BUS.addListener(LightTouchSpell::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            ItemStack tag;
            LivingEntity caster = (LivingEntity)entity;
            if (event.getEntity().getType().is(EntityTypeTags.UNDEAD) && (tag = caster.getMainHandItem()).isEmpty() && (Integer)tag.getOrDefault((DataComponentType)EidolonDataComponents.CONSECRATED.get(), (Object)0) > 0) {
                event.setNewDamage(event.getNewDamage() * 1.5f);
                tag.set(EidolonDataComponents.CONSECRATED, (Object)((Integer)tag.getOrDefault((DataComponentType)EidolonDataComponents.CONSECRATED.get(), (Object)1) - 1));
            }
        }
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (reputation == null) {
            return false;
        }
        if (reputation.getReputation(Deities.LIGHT_DEITY.getId()) < 10.0) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon.message.not_enough_reputation"), true);
            return false;
        }
        Vec3 v = LightTouchSpell.getVector(world, player);
        List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(v.x - 1.5, v.y - 1.5, v.z - 1.5, v.x + 1.5, v.y + 1.5, v.z + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.get(0)).getItem();
        return stack.getCount() == 1 && this.canTouch(stack);
    }

    @Override
    boolean canTouch(ItemStack stack) {
        return stack.getItem() == Registry.GOLD_INLAY.get() || stack.getItem() == Items.BLACK_WOOL || stack.is(Tags.Items.MUSIC_DISCS) && stack.getItem() != Registry.PAROUSIA_DISC.get() || stack.isDamageableItem() && stack.getMaxStackSize() == 1;
    }

    @Override
    protected ItemStack touchResult(ItemStack stack, Player player) {
        if (stack.getItem() == Registry.GOLD_INLAY.get()) {
            return new ItemStack((ItemLike)Registry.HOLY_SYMBOL.get());
        }
        if (stack.getItem() == Items.BLACK_WOOL) {
            return new ItemStack((ItemLike)Registry.TOP_HAT.get());
        }
        if (stack.is(Tags.Items.MUSIC_DISCS) && stack.getItem() != Registry.PAROUSIA_DISC.get()) {
            return new ItemStack((ItemLike)Registry.PAROUSIA_DISC.get());
        }
        IMana.expendMana(player, this.getCost());
        stack.set(EidolonDataComponents.CONSECRATED, (Object)50);
        return stack;
    }
}

