/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.network.MagicBurstEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.util.DamageTypeData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class DarkTouchSpell
extends StaticSpell {
    public DarkTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, 20, signs);
        NeoForge.EVENT_BUS.addListener(DarkTouchSpell::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            ItemStack itemStack;
            LivingEntity living = (LivingEntity)entity;
            if (!event.getSource().is(DamageTypes.WITHER) && (itemStack = living.getMainHandItem()).has(EidolonDataComponents.NECROTIC)) {
                float amount = Math.min(1.0f, event.getNewDamage());
                event.setNewDamage(event.getNewDamage() - amount);
                int prevHurtResist = event.getEntity().invulnerableTime;
                event.getEntity().invulnerableTime = 0;
                if (event.getEntity().hurt(DamageTypeData.source((LevelAccessor)living.level(), (ResourceKey<DamageType>)DamageTypes.WITHER, (Entity)living, null), amount)) {
                    itemStack.set(EidolonDataComponents.NECROTIC, (Object)((Integer)itemStack.getOrDefault(EidolonDataComponents.NECROTIC, (Object)1) - 1));
                    living.invulnerableTime = prevHurtResist;
                }
            }
        }
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (reputation == null) {
            return false;
        }
        if (reputation.getReputation(Deities.DARK_DEITY.getId()) < 10.0) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon.message.not_enough_reputation"), true);
            return false;
        }
        Vec3 v = DarkTouchSpell.getVector(world, player);
        List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(v.x - 1.5, v.y - 1.5, v.z - 1.5, v.x + 1.5, v.y + 1.5, v.z + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.getFirst()).getItem();
        return stack.getCount() == 1 && this.canTouch(stack);
    }

    boolean canTouch(ItemStack stack) {
        return stack.getItem() == Registry.PEWTER_INLAY.get() || stack.getItem() == Items.BLACK_WOOL || stack.is(Tags.Items.MUSIC_DISCS) && stack.getItem() != Registry.PAROUSIA_DISC.get() || stack.isDamageableItem() && stack.getMaxStackSize() == 1;
    }

    protected ItemStack touchResult(ItemStack stack, Player player) {
        if (stack.getItem() == Registry.PEWTER_INLAY.get()) {
            return new ItemStack((ItemLike)Registry.UNHOLY_SYMBOL.get());
        }
        if (stack.getItem() == Items.BLACK_WOOL) {
            return new ItemStack((ItemLike)Registry.TOP_HAT.get());
        }
        if (stack.is(Tags.Items.MUSIC_DISCS) && stack.getItem() != Registry.PAROUSIA_DISC.get()) {
            return new ItemStack((ItemLike)Registry.PAROUSIA_DISC.get());
        }
        IMana.expendMana(player, this.getCost());
        stack.set(EidolonDataComponents.NECROTIC, (Object)50);
        return stack;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        Vec3 v = DarkTouchSpell.getVector(world, player);
        List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(v.x - 1.5, v.y - 1.5, v.z - 1.5, v.x + 1.5, v.y + 1.5, v.z + 1.5));
        if (items.size() == 1) {
            if (!world.isClientSide) {
                ItemStack stack = ((ItemEntity)items.getFirst()).getItem();
                if (this.canTouch(stack)) {
                    ((ItemEntity)items.getFirst()).setItem(this.touchResult(stack, player));
                    Vec3 p = ((ItemEntity)items.getFirst()).position();
                    ((ItemEntity)items.getFirst()).setDefaultPickUpDelay();
                    Networking.sendToNearbyClient(world, ((ItemEntity)items.getFirst()).blockPosition(), (CustomPacketPayload)new MagicBurstEffectPacket(p.x, p.y, p.z, Signs.WICKED_SIGN.color(), Signs.BLOOD_SIGN.color()));
                }
            } else {
                world.playSound(player, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 1.0f, 0.6f + world.random.nextFloat() * 0.2f);
            }
        }
    }
}

