/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.api.capability.IKnowledge;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.codex.Chapter;
import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.Page;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonSounds;
import alexthw.eidolon_repraised.util.ClientInfo;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SignIndexPage
extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_sign_index_page.png");
    final List<SignEntry> entries = new ArrayList<SignEntry>();

    public SignIndexPage(SignEntry ... pages) {
        super(BACKGROUND);
        this.entries.addAll(List.of(pages));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity == null) {
            return false;
        }
        IKnowledge knowledge = (IKnowledge)entity.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int xx = x + 8 + i % 2 * 56;
            int yy = y + 4 + i / 2 * 52;
            if (knowledge.knowsSign(this.entries.get((int)i).sign) && mouseX >= xx + 38 && mouseY >= yy + 38 && mouseX <= xx + 50 && mouseY <= yy + 50) {
                gui.changeChapter(this.entries.get((int)i).chapter);
                Minecraft.getInstance().player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return true;
            }
            if (!knowledge.knowsSign(this.entries.get((int)i).sign) || mouseX < xx || mouseX > xx + 48 || mouseY < yy || mouseY > yy + 48) continue;
            gui.addToChant(this.entries.get((int)i).sign);
            entity.playNotifySound((SoundEvent)EidolonSounds.SELECT_RUNE.get(), SoundSource.NEUTRAL, 0.5f, entity.level().random.nextFloat() * 0.25f + 0.75f);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity == null) {
            return;
        }
        IKnowledge knowledge = (IKnowledge)entity.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        PoseStack mStack = guiGraphics.pose();
        if (knowledge == null) {
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int xx = x + 8 + i % 2 * 56;
            int yy = y + 4 + i / 2 * 52;
            Sign sign = this.entries.get((int)i).sign;
            boolean hover = knowledge.knowsSign(sign) && mouseX >= xx && mouseX <= xx + 48 && mouseY >= yy && mouseY <= yy + 48;
            boolean infoHover = knowledge.knowsSign(sign) && mouseX >= xx + 38 && mouseY >= yy + 38 && mouseX <= xx + 50 && mouseY <= yy + 50;
            guiGraphics.blit(BACKGROUND, xx, yy, knowledge.knowsSign(this.entries.get((int)i).sign) ? 128 : 176, 0, 48, 48);
            if (!knowledge.knowsSign(sign)) continue;
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
            if (hover && !infoHover) {
                mStack.pushPose();
                mStack.translate((float)(xx + 24), (float)(yy + 24), 0.0f);
                mStack.mulPose(Axis.ZP.rotationDegrees(ClientInfo.getClientPartialTicks() * 1.5f));
                SignIndexPage.colorBlit(mStack, -18, -18, 128, 48, 36, 36, 256, 256, sign.color());
                mStack.popPose();
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            for (int j = 0; j < (hover && !infoHover ? 2 : 1); ++j) {
                RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, xx + 12, yy + 12, 24.0, 24.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(sign.sprite()));
                bufferSource.endBatch();
            }
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            guiGraphics.blit(BACKGROUND, xx + 38, yy + 38, infoHover ? 188 : 176, 48, 12, 14);
            if (!infoHover) continue;
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"eidolon.codex.sign_suffix", (Object[])new Object[]{Component.translatable((String)(sign.getRegistryName().getNamespace() + ".sign." + sign.getRegistryName().getPath()))}), mouseX, mouseY);
        }
    }

    public static class SignEntry {
        final Chapter chapter;
        final Sign sign;

        public SignEntry(Chapter chapter, Sign sign) {
            this.chapter = chapter;
            this.sign = sign;
        }
    }
}

