/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.ritual.FocusItemPresentRequirement;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.RecipePage;
import alexthw.eidolon_repraised.common.ritual.CraftingRitual;
import alexthw.eidolon_repraised.recipe.RitualRecipe;
import alexthw.eidolon_repraised.util.RegistryUtil;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualPage
extends RecipePage<RitualRecipe> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_ritual_page.png");
    Ritual ritual;
    Ingredient center;
    RitualIngredient[] inputs;

    public RitualPage(ResourceLocation background, ResourceLocation recipeName, ItemStack empty) {
        super(background, recipeName.getNamespace().equals("eidolon_repraised") ? Eidolon.prefix("rituals/" + recipeName.getPath()) : recipeName, empty);
    }

    public static void renderRitualSymbol(@NotNull GuiGraphics guiGraphics, int x, int y, Ritual ritual) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        MultiBufferSource.BufferSource buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(ClientRegistry::getGlowingShader);
        RenderUtil.dragon(guiGraphics.pose(), (MultiBufferSource)buffersource, x + 64, y + 48, 20.0, 20.0f, ritual.getRed(), ritual.getGreen(), ritual.getBlue());
        buffersource.endBatch();
        RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        for (int j = 0; j < 2; ++j) {
            RenderUtil.litQuad(guiGraphics.pose(), (MultiBufferSource)buffersource, x + 52, y + 36, 24.0, 24.0, ritual.getRed(), ritual.getGreen(), ritual.getBlue(), (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ritual.getSymbol()));
            buffersource.endBatch();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    public static void rearrangeIngredients(@NotNull RitualRecipe recipe, List<RitualIngredient> inputs) {
        for (Ingredient ingredient : recipe.pedestalItems) {
            inputs.add(new RitualIngredient(ingredient, false));
        }
        int nIngredients = inputs.size();
        int middle = nIngredients / 2;
        List<Ingredient> focusItems = recipe.focusItems;
        for (int i = 0; i < focusItems.size(); ++i) {
            Ingredient ingredient = focusItems.get(i);
            inputs.add(i + middle, new RitualIngredient(ingredient, true));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RitualRecipe getRecipe(ResourceLocation id) {
        RitualRecipe ritualRecipe;
        Recipe recipe;
        Optional recipeHolder = Eidolon.proxy.getWorld().getRecipeManager().byKey(id);
        if (recipeHolder.isEmpty() || !((recipe = ((RecipeHolder)recipeHolder.get()).value()) instanceof RitualRecipe)) {
            ritualRecipe = null;
        } else {
            void var3_4;
            RitualRecipe recipe2 = (RitualRecipe)recipe;
            ritualRecipe = var3_4;
        }
        return ritualRecipe;
    }

    public RitualPage(ResourceLocation recipeName) {
        this(BACKGROUND, recipeName, ItemStack.EMPTY);
    }

    public RitualPage(ResourceLocation recipeName, ItemStack result) {
        this(BACKGROUND, recipeName, result);
    }

    public RitualPage(Ritual ritual) {
        ItemStack itemStack;
        ResourceLocation resourceLocation;
        if (ritual instanceof CraftingRitual) {
            CraftingRitual cr = (CraftingRitual)ritual;
            resourceLocation = RegistryUtil.getRegistryName(cr.getResult().getItem());
        } else {
            resourceLocation = Eidolon.prefix("ritual_" + ritual.getRegistryName().getPath());
        }
        if (ritual instanceof CraftingRitual) {
            CraftingRitual sr = (CraftingRitual)ritual;
            itemStack = sr.getResult();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this(BACKGROUND, resourceLocation, itemStack);
        this.ritual = ritual;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        if (this.cachedRecipe == null) {
            return;
        }
        if (this.inputs == null || this.center == null) {
            int nIngredients = ((RitualRecipe)this.cachedRecipe).pedestalItems.size() + ((RitualRecipe)this.cachedRecipe).focusItems.size();
            if (nIngredients > 0) {
                ArrayList<RitualIngredient> items = new ArrayList<RitualIngredient>(nIngredients);
                RitualPage.rearrangeIngredients((RitualRecipe)this.cachedRecipe, items);
                this.inputs = items.toArray(new RitualIngredient[nIngredients]);
                this.center = ((RitualRecipe)this.cachedRecipe).reagent;
            } else {
                return;
            }
        }
        float angleStep = Math.min(30, 180 / this.inputs.length);
        double rootAngle = 90.0f - (float)(this.inputs.length - 1) * angleStep / 2.0f;
        for (int i = 0; i < this.inputs.length; ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(64.0 + 48.0 * Math.cos(a));
            int dy = (int)(88.0 + 48.0 * Math.sin(a));
            if (this.inputs[i].isFocus) {
                guiGraphics.blit(bg, x + dx - 13, y + dy - 13, 128, 0, 26, 24);
                continue;
            }
            guiGraphics.blit(bg, x + dx - 8, y + dy - 8, 154, 0, 16, 16);
        }
        if (this.ritual == null) {
            this.ritual = ((RitualRecipe)this.cachedRecipe).getRitual();
            if (this.ritual == null) {
                return;
            }
        }
        if (this.ritual.getInvariants().stream().anyMatch(FocusItemPresentRequirement.class::isInstance)) {
            guiGraphics.blit(bg, x + 86 - 5, y + 80 - 5, 128, 0, 26, 24);
        }
        RitualPage.renderRitualSymbol(guiGraphics, x, y, this.ritual);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderIngredients(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        if (this.cachedRecipe == null || this.inputs == null || this.inputs.length == 0 || this.center == null) {
            return;
        }
        float angleStep = Math.min(30, 180 / this.inputs.length);
        double rootAngle = 90.0f - (float)(this.inputs.length - 1) * angleStep / 2.0f;
        for (int i = 0; i < this.inputs.length; ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(64.0 + 48.0 * Math.cos(a));
            int dy = (int)(88.0 + 48.0 * Math.sin(a));
            RitualPage.drawItems(mStack, this.inputs[i].stack, x + dx - 8, y + dy - 8, mouseX, mouseY);
        }
        RitualPage.drawItems(mStack, this.center, x + 56, y + 80, mouseX, mouseY);
        if (this.ritual != null) {
            FocusItemPresentRequirement invariants = this.ritual.getInvariants().stream().filter(FocusItemPresentRequirement.class::isInstance).map(FocusItemPresentRequirement.class::cast).findFirst().orElse(null);
            if (invariants == null) {
                return;
            }
            RitualPage.drawItems(mStack, invariants.getMatch(), x + 86, y + 80, mouseX, mouseY);
        }
    }

    public static class RitualIngredient {
        public final Ingredient stack;
        public boolean isFocus;

        public RitualIngredient(Ingredient stack, boolean isFocus) {
            this.stack = stack;
            this.isFocus = isFocus;
        }

        public RitualIngredient(ItemLike stack, boolean isFocus) {
            this.stack = Ingredient.of((ItemLike[])new ItemLike[]{stack});
            this.isFocus = isFocus;
        }
    }
}

