/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.api.altar.AltarEntry;
import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.Page;
import alexthw.eidolon_repraised.registries.AltarEntries;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ListPage
extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_index_page.png");
    final ListEntry[] entries;
    final String key;

    public ListPage(String key, ListEntry ... pages) {
        super(BACKGROUND);
        this.key = key;
        this.entries = pages;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics mStack, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        int i;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        for (i = 0; i < this.entries.length; ++i) {
            mStack.blit(BACKGROUND, x + 1, y + 7 + i * 20, 128, 0, 122, 18);
        }
        for (i = 0; i < this.entries.length; ++i) {
            ItemStack icon = this.entries[i].icon;
            AltarEntry entry = this.entries[i].entry;
            ListPage.drawItem(mStack, icon, x + 2, y + 8 + i * 20, mouseX, mouseY);
            Object text = "";
            try {
                if (entry.getPower() > 0.0) {
                    text = (String)text + (int)entry.getPower() + " " + I18n.get((String)"eidolon.codex.altar_power", (Object[])new Object[0]);
                }
                if (entry.getCapacity() > 0.0) {
                    if (!((String)text).isEmpty()) {
                        text = (String)text + ", ";
                    }
                    text = (String)text + (int)entry.getCapacity() + " " + I18n.get((String)"eidolon.codex.altar_capacity", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                text = "Invalid Entry. Likely mod conflict.";
            }
            Objects.requireNonNull(Minecraft.getInstance().font);
            ListPage.drawText(mStack, (String)text, x + 24, y + 20 + i * 20 - 9);
        }
    }

    public static class ListEntry {
        final String key;
        final ItemStack icon;
        private final AltarEntry entry;

        public ListEntry(String key, ItemStack icon) {
            this.key = key;
            this.icon = icon;
            this.entry = AltarEntries.find(icon.getItem());
        }

        public ListEntry(String key, ItemStack icon, Block entry) {
            this.key = key;
            this.icon = icon;
            this.entry = AltarEntries.find(entry);
        }
    }
}

