/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.particle;

import alexthw.eidolon_repraised.api.spells.Rune;
import alexthw.eidolon_repraised.client.ClientConfig;
import alexthw.eidolon_repraised.client.particle.RuneParticleData;
import alexthw.eidolon_repraised.client.particle.RuneParticleRenderType;
import alexthw.eidolon_repraised.event.ClientEvents;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RuneParticle
extends TextureSheetParticle {
    final Rune rune;
    final float[] hsv1 = new float[3];
    final float[] hsv2 = new float[3];

    public RuneParticle(ClientLevel world, RuneParticleData data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.setPos(x, y, z);
        this.rune = data.rune;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.setLifetime(20);
        this.gravity = -0.05f;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        if ((double)this.hsv1[0] < 0.01) {
            this.hsv1[0] = this.hsv2[0];
        }
        if ((double)this.hsv1[1] < 0.01) {
            this.hsv1[1] = 0.01f;
        }
        this.updateTraits();
    }

    protected float getCoeff() {
        float t = ((float)this.age + (float)Minecraft.getInstance().getFrameTimeNs()) / (float)this.lifetime;
        t = Mth.clamp((float)t, (float)0.001f, (float)0.999f);
        float ic = (1.0f - t) * (1.0f - t);
        return 1.0f - (Mth.sin((float)((float)Math.PI * 4 * t)) * ic * 0.5f - 0.7f * t + 0.7f);
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        float t = ((float)this.age + (float)Minecraft.getInstance().getFrameTimeNs()) / (float)this.lifetime;
        t = Mth.clamp((float)t, (float)0.001f, (float)0.999f);
        float ic = (1.0f - t) * (1.0f - t);
        this.quadSize = Mth.lerp((float)coeff, (float)0.125f, (float)0.0625f);
        this.oRoll = this.roll;
        this.roll = (float)Math.PI * Mth.sin((float)(Mth.cos((float)((float)Math.PI * 4 * t)) * ic)) / 8.0f;
        this.setAlpha(Mth.lerp((float)(coeff * coeff), (float)0.5f, (float)0.0f));
        float h = Mth.rotLerp((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.lerp((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.lerp((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.red((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packed) / 255.0f;
        this.setColor(r, g, b);
    }

    public void tick() {
        this.updateTraits();
        super.tick();
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
    }

    public void render(@NotNull VertexConsumer b, Camera info, float pticks) {
        Quaternionf quaternion;
        b = (Boolean)ClientConfig.BETTER_LAYERING.get() != false ? ClientEvents.getDelayedRender().getBuffer(RenderUtil.GLOWING_BLOCK_PARTICLE) : b;
        Vec3 vec3 = info.getPosition();
        float f = (float)(Mth.lerp((double)pticks, (double)this.xo, (double)this.x) - vec3.x());
        float f1 = (float)(Mth.lerp((double)pticks, (double)this.yo, (double)this.y) - vec3.y());
        float f2 = (float)(Mth.lerp((double)pticks, (double)this.zo, (double)this.z) - vec3.z());
        if (this.roll == 0.0f) {
            quaternion = info.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)info.rotation());
            float f3 = Mth.lerp((float)pticks, (float)this.oRoll, (float)this.roll);
            quaternion.mul((Quaternionfc)Axis.ZP.rotation(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getQuadSize(pticks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        int j = this.getLightColor(pticks);
        Vector3f offX = new Vector3f((Vector3fc)avector3f[0]);
        Vector3f offY = new Vector3f((Vector3fc)avector3f[1]);
        offX.sub((Vector3fc)avector3f[2]);
        offX.mul(0.5f);
        offY.sub((Vector3fc)avector3f[3]);
        offY.mul(0.5f);
        TextureAtlasSprite aura = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/aura"));
        for (int i = 0; i < 1; ++i) {
            b.addVertex(avector3f[0].x() + offX.x(), avector3f[0].y() + offX.y(), avector3f[0].z() + offX.z()).setUv(aura.getU1(), aura.getV1()).setColor(this.rCol, this.gCol, this.bCol, this.alpha * 0.25f).setLight(j);
            b.addVertex(avector3f[1].x() + offY.x(), avector3f[1].y() + offY.y(), avector3f[1].z() + offY.z()).setUv(aura.getU1(), aura.getV0()).setColor(this.rCol, this.gCol, this.bCol, this.alpha * 0.25f).setLight(j);
            b.addVertex(avector3f[2].x() - offX.x(), avector3f[2].y() - offX.y(), avector3f[2].z() - offX.z()).setUv(aura.getU0(), aura.getV0()).setColor(this.rCol, this.gCol, this.bCol, this.alpha * 0.25f).setLight(j);
            b.addVertex(avector3f[3].x() - offY.x(), avector3f[3].y() - offY.y(), avector3f[3].z() - offY.z()).setUv(aura.getU0(), aura.getV1()).setColor(this.rCol, this.gCol, this.bCol, this.alpha * 0.25f).setLight(j);
        }
        b.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        b.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        b.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        b.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return RuneParticleRenderType.INSTANCE;
    }
}

