/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.ISoul;
import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.client.ClientConfig;
import alexthw.eidolon_repraised.common.item.IManaRelatedItem;
import alexthw.eidolon_repraised.common.item.IWingsItem;
import alexthw.eidolon_repraised.event.ClientEvents;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonPotions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EidolonOverlays {
    protected static final ResourceLocation ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/icons.png");
    protected static final ResourceLocation MANA_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/mana_bar.png");
    private static final Minecraft minecraft = Minecraft.getInstance();

    public static class EidolonRavenCharge
    implements LayeredDraw.Layer {
        protected static final ResourceLocation GUI_ICONS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/icons.png");

        public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
            PoseStack mStack = guiGraphics.pose();
            LocalPlayer player = EidolonOverlays.minecraft.player;
            Font font = EidolonOverlays.minecraft.font;
            int screenWidth = guiGraphics.guiWidth();
            int screenHeight = guiGraphics.guiHeight();
            if (player == null || player.isCreative() || player.isSpectator() || player.onGround()) {
                return;
            }
            WingsDataImpl wingsCap = (WingsDataImpl)player.getCapability(EidolonCapabilities.WINGS_CAPABILITY);
            if (wingsCap != null) {
                ItemStack wings = wingsCap.getWingsItem((Player)player);
                Item item = wings.getItem();
                if (!(item instanceof IWingsItem)) {
                    return;
                }
                IWingsItem wing = (IWingsItem)item;
                int remainingFlaps = wingsCap.getWingCharges((Player)player);
                String s = "" + remainingFlaps;
                int i1 = (screenWidth - font.width(s)) / 2;
                int j1 = screenHeight - 46;
                guiGraphics.drawString(font, s, i1 + 1, j1, 0, false);
                guiGraphics.drawString(font, s, i1 - 1, j1, 0, false);
                guiGraphics.drawString(font, s, i1, j1 + 1, 0, false);
                guiGraphics.drawString(font, s, i1, j1 - 1, 0, false);
                guiGraphics.drawString(font, s, i1, j1, 6505166, false);
                if (ClientEvents.jumpTicks >= 5) {
                    RenderSystem.enableBlend();
                    int x = screenWidth / 2 - 91;
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    minecraft.getProfiler().push("ravenJumpBar");
                    float f = (float)((long)(ClientEvents.jumpTicks - 5) + Minecraft.getInstance().getFrameTimeNs()) / 15.0f;
                    int i = 182;
                    int j = (int)(f * 183.0f);
                    int k = guiGraphics.guiHeight() - 32 + 3;
                    guiGraphics.blit(GUI_ICONS_LOCATION, x, k, 0, 84, 182, 5);
                    if (j > 0) {
                        guiGraphics.blit(GUI_ICONS_LOCATION, x, k, 0, 89, j, 5);
                    }
                    minecraft.getProfiler().pop();
                    RenderSystem.disableBlend();
                    minecraft.getProfiler().pop();
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    public static class EidolonHearts
    implements LayeredDraw.Layer {
        float lastEtherealHealth = 0.0f;
        long healthBlinkTime = 0L;
        long lastHealthTime = 0L;

        public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
            int y;
            int x;
            int heart;
            int row;
            int i;
            int ticks;
            boolean highlight;
            PoseStack mStack = guiGraphics.pose();
            LocalPlayer player = EidolonOverlays.minecraft.player;
            if (EidolonOverlays.minecraft.gameMode.canHurtPlayer() || player == null) {
                return;
            }
            mStack.pushPose();
            mStack.translate(0.0, 0.0, 0.01);
            int health = Mth.ceil((float)player.getHealth());
            float absorb = Mth.ceil((float)player.getAbsorptionAmount());
            AttributeInstance attrMaxHealth = player.getAttribute(Attributes.MAX_HEALTH);
            float healthMax = (float)attrMaxHealth.getValue();
            float etherealHealth = 0.0f;
            float etherealMax = 0.0f;
            ISoul cap = (ISoul)player.getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY);
            if (cap != null) {
                etherealHealth = cap.getEtherealHealth();
                etherealMax = cap.getMaxEtherealHealth();
            }
            boolean bl = highlight = this.healthBlinkTime > (long)(ticks = (int)deltaTracker.getGameTimeDeltaTicks()) && (this.healthBlinkTime - (long)ticks) / 3L % 2L == 1L;
            if (etherealHealth < this.lastEtherealHealth && player.invulnerableTime > 0) {
                this.lastHealthTime = Util.getMillis();
                this.healthBlinkTime = ticks + 20;
            } else if (etherealHealth > this.lastEtherealHealth) {
                this.lastHealthTime = Util.getMillis();
                this.healthBlinkTime = ticks + 10;
            }
            if (Util.getMillis() - this.lastHealthTime > 1000L) {
                this.lastEtherealHealth = health;
                this.lastHealthTime = Util.getMillis();
            }
            this.lastEtherealHealth = etherealHealth;
            float f = Math.max((float)player.getAttributeValue(Attributes.MAX_HEALTH), (float)health);
            int regen = -1;
            if (player.hasEffect(MobEffects.REGENERATION)) {
                regen = ticks % Mth.ceil((float)(f + 5.0f));
            }
            Random rand = new Random();
            rand.setSeed((long)ticks * 312871L);
            int absorptionHearts = Mth.ceil((float)(absorb / 2.0f)) - 1;
            int hearts = Mth.ceil((float)(healthMax / 2.0f)) - 1;
            int ethHearts = Mth.ceil((float)(etherealMax / 2.0f));
            int healthRows = Mth.ceil((float)((healthMax + absorb) / 2.0f / 10.0f));
            int totalHealthRows = Mth.ceil((float)((healthMax + absorb + etherealMax) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            int extraHealthRows = totalHealthRows - healthRows;
            int extraRowHeight = Mth.clamp((int)(10 - (healthRows - 2)), (int)3, (int)10);
            int left = guiGraphics.guiWidth() / 2 - 91;
            int top = guiGraphics.guiHeight() - EidolonOverlays.minecraft.gui.leftHeight + healthRows * rowHeight;
            if (rowHeight != 10) {
                top += 10 - rowHeight;
            }
            EidolonOverlays.minecraft.gui.leftHeight += extraHealthRows * extraRowHeight;
            for (i = absorptionHearts + hearts + ethHearts; i > absorptionHearts + hearts; --i) {
                row = (i + 1) / 10;
                heart = (i + 1) % 10;
                x = left + heart * 8;
                y = top - extraRowHeight * Math.max(0, row - healthRows + 1) - rowHeight * Math.min(row, healthRows - 1);
                guiGraphics.blit(ICONS_TEXTURE, x, y, highlight ? 9 : 0, 18, 9, 9);
            }
            for (i = absorptionHearts + hearts + ethHearts; i > absorptionHearts + hearts; --i) {
                row = (i + 1) / 10;
                heart = (i + 1) % 10;
                x = left + heart * 8;
                y = top - extraRowHeight * Math.max(0, row - healthRows + 1) - rowHeight * Math.min(row, healthRows - 1);
                int i2 = i - (Mth.ceil((float)((healthMax + absorb) / 2.0f)) - 1);
                if ((float)(i2 * 2 + 1) < etherealHealth) {
                    guiGraphics.blit(ICONS_TEXTURE, x, y, 0, 9, 9, 9);
                    continue;
                }
                if ((float)(i2 * 2 + 1) != etherealHealth) continue;
                guiGraphics.blit(ICONS_TEXTURE, x, y, 9, 9, 9, 9);
            }
            for (i = Mth.ceil((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                row = i / 10;
                heart = i % 10;
                x = left + heart * 8;
                y = top - row * rowHeight;
                if (health <= 4) {
                    y += rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                RenderSystem.enableBlend();
                if (player.hasEffect(EidolonPotions.CHILLED_EFFECT) && i <= Mth.ceil((float)(healthMax / 2.0f)) - 1) {
                    if (i * 2 + 1 < health) {
                        guiGraphics.blit(ICONS_TEXTURE, x, y, 0, 0, 9, 9);
                    } else if (i * 2 + 1 == health) {
                        guiGraphics.blit(ICONS_TEXTURE, x, y, 9, 0, 9, 9);
                    }
                }
                RenderSystem.disableBlend();
            }
            mStack.popPose();
        }
    }

    public static class EidolonManaBar
    implements LayeredDraw.Layer {
        int xPos() {
            String origin = (String)ClientConfig.MANA_BAR_POSITION.get();
            if (origin.equals("bottomLeft") || origin.equals("left") || origin.equals("topLeft")) {
                return -1;
            }
            if (origin.equals("bottomRight") || origin.equals("right") || origin.equals("topRight")) {
                return 1;
            }
            return 0;
        }

        int yPos() {
            String origin = (String)ClientConfig.MANA_BAR_POSITION.get();
            if (origin.equals("top") || origin.equals("topLeft")) {
                return -1;
            }
            if (origin.equals("bottomLeft") || origin.equals("bottomRight")) {
                return 1;
            }
            return 0;
        }

        boolean horiz() {
            String orient = (String)ClientConfig.MANA_BAR_ORIENTATION.get();
            String origin = (String)ClientConfig.MANA_BAR_POSITION.get();
            if (orient.equals("horizontal")) {
                return true;
            }
            if (orient.equals("vertical")) {
                return false;
            }
            return !origin.equals("left") && !origin.equals("right");
        }

        public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            PoseStack mStack = guiGraphics.pose();
            if (player == null) {
                return;
            }
            int xp = this.xPos();
            int yp = this.yPos();
            boolean isHoriz = this.horiz();
            int width = guiGraphics.guiWidth();
            int height = guiGraphics.guiHeight();
            int w = isHoriz ? 120 : 28;
            int h = isHoriz ? 28 : 120;
            int ox = width / 2 - w / 2;
            int oy = height / 2 - h / 2;
            if (isHoriz) {
                if (yp == -1) {
                    oy = 4;
                } else if (yp == 1) {
                    oy = height + 4 - h;
                }
                if (xp == -1) {
                    ox = 8;
                } else if (xp == 1) {
                    ox = width - 4 - w;
                }
            } else {
                if (yp == -1) {
                    oy = -8;
                } else if (yp == 1) {
                    oy = height - 20 - h;
                }
                if (xp == -1) {
                    ox = 4;
                } else if (xp == 1) {
                    ox = width + 4 - w;
                }
            }
            int barlength = 114;
            float magic = 0.0f;
            float maxMagic = 0.0f;
            try {
                IMana soul = (IMana)player.getCapability(EidolonCapabilities.MANA_CAPABILITY);
                if (soul == null) {
                    return;
                }
                magic = soul.getMagic();
                maxMagic = soul.getMaxMagic();
            }
            catch (Exception soul) {
                // empty catch block
            }
            if (maxMagic == 0.0f) {
                return;
            }
            if (!(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof IManaRelatedItem) && !(player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof IManaRelatedItem)) {
                return;
            }
            int length = Mth.ceil((float)(114.0f * magic / maxMagic));
            int iconU = 48;
            int iconV = 48;
            mStack.pushPose();
            mStack.translate(0.0, 0.0, 0.01);
            if (isHoriz) {
                guiGraphics.blit(MANA_BAR_TEXTURE, ox -= 4, oy, 2, length == 0 ? 6 : 38, 6, 20);
                if (xp > 0) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox - 23, oy - 2, 0, 64, 24, 24);
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox - 18, oy + 4, iconU, iconV, 12, 12);
                }
                int firstSegment = Math.min(8, length);
                length -= firstSegment;
                guiGraphics.blit(MANA_BAR_TEXTURE, ox += 6, oy, 8, 38, firstSegment, 20);
                ox += firstSegment;
                if (firstSegment < 8) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy, 8 + firstSegment, 6, 8 - firstSegment, 20);
                    ox += 8 - firstSegment;
                }
                for (int i = 0; i < 6; ++i) {
                    int segment = Math.min(16, length);
                    length -= segment;
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy, 16, 38, segment, 20);
                    ox += segment;
                    if (segment >= 16) continue;
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy, 16 + segment, 6, 16 - segment, 20);
                    ox += 16 - segment;
                }
                int lastSegment = Math.min(8, length);
                length -= lastSegment;
                guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy, 32, 38, lastSegment, 20);
                ox += lastSegment;
                if (lastSegment < 8) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy, 32 + lastSegment, 6, 8 - lastSegment, 20);
                    ox += 8 - lastSegment;
                }
                guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy, 40, Mth.ceil((float)(114.0f * magic / maxMagic)) == 114 ? 6 : 38, 7, 20);
                if (xp <= 0) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox + 5, oy - 2, 32, 64, 24, 24);
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox + 12, oy + 4, iconU, iconV, 12, 12);
                }
            } else {
                oy += 16;
                guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy += 114, length == 0 ? 54 : 86, 40, 20, 6);
                if (yp < 0) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox - 2, oy + 5, 32, 96, 24, 24);
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox + 4, oy + 12, iconU, iconV, 12, 12);
                }
                int firstSegment = Math.min(8, length);
                length -= firstSegment;
                guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= firstSegment, 86, 32, 20, firstSegment);
                if (firstSegment < 8) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= 8 - firstSegment, 54, 32 + firstSegment, 20, 8 - firstSegment);
                }
                for (int i = 0; i < 6; ++i) {
                    int segment = Math.min(16, length);
                    length -= segment;
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= segment, 86, 16, 20, segment);
                    if (segment >= 16) continue;
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= 16 - segment, 54, 16 + segment, 20, 16 - segment);
                }
                int lastSegment = Math.min(8, length);
                length -= lastSegment;
                guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= lastSegment, 86, 8, 20, lastSegment);
                if (lastSegment < 8) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= 8 - lastSegment, 54, 8 + lastSegment, 20, 8 - lastSegment);
                }
                guiGraphics.blit(MANA_BAR_TEXTURE, ox, oy -= 6, Mth.ceil((float)(114.0f * magic / maxMagic)) == 114 ? 54 : 86, 2, 20, 6);
                if (yp >= 0) {
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox - 2, oy - 23, 0, 96, 24, 24);
                    guiGraphics.blit(MANA_BAR_TEXTURE, ox + 4, oy - 18, iconU, iconV, 12, 12);
                }
            }
            mStack.popPose();
        }
    }
}

