/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised;

import alexthw.eidolon_repraised.Config;
import alexthw.eidolon_repraised.client.ClientConfig;
import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.client.EidolonOverlays;
import alexthw.eidolon_repraised.common.item.AthameItem;
import alexthw.eidolon_repraised.common.tile.BrazierTileRenderer;
import alexthw.eidolon_repraised.common.tile.CenserRenderer;
import alexthw.eidolon_repraised.common.tile.CrucibleTileRenderer;
import alexthw.eidolon_repraised.common.tile.GobletTileRenderer;
import alexthw.eidolon_repraised.common.tile.HandTileRenderer;
import alexthw.eidolon_repraised.common.tile.NecroticFocusTileRenderer;
import alexthw.eidolon_repraised.common.tile.SoulEnchanterTileRenderer;
import alexthw.eidolon_repraised.compat.CompatHandler;
import alexthw.eidolon_repraised.event.Events;
import alexthw.eidolon_repraised.mixin.BlockEntityTypeAccessor;
import alexthw.eidolon_repraised.network.InitCodexPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.proxy.ClientProxy;
import alexthw.eidolon_repraised.proxy.ISidedProxy;
import alexthw.eidolon_repraised.proxy.ServerProxy;
import alexthw.eidolon_repraised.registries.AltarEntries;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import alexthw.eidolon_repraised.registries.IncenseRegistry;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Researches;
import alexthw.eidolon_repraised.registries.RitualRegistry;
import alexthw.eidolon_repraised.registries.Runes;
import alexthw.eidolon_repraised.registries.Spells;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="eidolon_repraised")
public class Eidolon {
    public static ISidedProxy proxy;
    public static final String MODID = "eidolon_repraised";
    public static final Logger LOG;
    public static boolean trueMobType;

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static boolean isValidUndead(LivingEntity e) {
        trueMobType = true;
        boolean type = e.getType().getTags().toList().contains(EntityTypeTags.UNDEAD);
        trueMobType = false;
        return type;
    }

    public Eidolon(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::sendImc);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.register((Object)new Registry());
        Registry.init(modEventBus);
        modEventBus.addListener(Networking::register);
        NeoForge.EVENT_BUS.register((Object)new Events());
        CompatHandler.initialize();
        proxy = FMLEnvironment.dist.isClient() ? new Supplier<ISidedProxy>(this){

            @Override
            public ISidedProxy get() {
                return new ClientProxy();
            }
        }.get() : new ServerProxy();
        proxy.init(modEventBus);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Spells.init();
            RitualRegistry.init();
            IncenseRegistry.init();
            EidolonRecipes.ritualRecipeTypes.addAll(List.of((RecipeType)EidolonRecipes.CRAFTING_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.SUMMON_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.COMMAND_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.LOCATION_RITUAL_TYPE.get(), (RecipeType)EidolonRecipes.RITUAL_TYPE.get()));
            AltarEntries.init();
            Researches.init();
            Runes.init();
            AthameItem.initHarvestables();
            Eidolon.addBlocksToTile(BlockEntityType.SIGN, new Block[]{Registry.ILLWOOD_PLANKS.getStandingSign(), Registry.ILLWOOD_PLANKS.getWallSign(), Registry.POLISHED_PLANKS.getStandingSign(), Registry.POLISHED_PLANKS.getWallSign()});
            Eidolon.addBlocksToTile(BlockEntityType.HANGING_SIGN, new Block[]{Registry.ILLWOOD_PLANKS.getHangingSign(), Registry.ILLWOOD_PLANKS.getHangingWallSign(), Registry.POLISHED_PLANKS.getHangingSign(), Registry.POLISHED_PLANKS.getHangingWallSign()});
        });
    }

    public static void addBlocksToTile(BlockEntityType<?> bet, Block ... blocksToAdd) {
        Set<Block> oldSet = ((BlockEntityTypeAccessor)bet).getValidBlocks();
        if (oldSet instanceof ImmutableSet) {
            HashSet<Block> newSet = new HashSet<Block>();
            Collections.addAll(newSet, blocksToAdd);
            newSet.addAll(oldSet);
            ((BlockEntityTypeAccessor)bet).setValidBlocks(newSet);
        } else {
            Collections.addAll(oldSet, blocksToAdd);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.HAND_TILE_ENTITY.get()), trd -> new HandTileRenderer());
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.BRAZIER_TILE_ENTITY.get()), trd -> new BrazierTileRenderer());
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.NECROTIC_FOCUS_TILE_ENTITY.get()), trd -> new NecroticFocusTileRenderer());
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.CRUCIBLE_TILE_ENTITY.get()), trd -> new CrucibleTileRenderer());
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.SOUL_ENCHANTER_TILE_ENTITY.get()), trd -> new SoulEnchanterTileRenderer());
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.GOBLET_TILE_ENTITY.get()), trd -> new GobletTileRenderer());
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)Registry.CENSER_TILE_ENTITY.get()), trd -> new CenserRenderer());
        event.enqueueWork(() -> {
            ClientRegistry.initCurios();
            Sheets.addWoodType((WoodType)Registry.ILLWOOD);
            Sheets.addWoodType((WoodType)Registry.POLISHED);
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = Events.rightClickLectern(e.getEntity(), e.getLevel(), e.getHitVec());
            if (result.consumesAction()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> Networking.sendToPlayerClient(new InitCodexPacket(null), (ServerPlayer)e.getEntity()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerOverlays(RegisterGuiLayersEvent evt) {
        evt.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, Eidolon.prefix("hearts"), (LayeredDraw.Layer)new EidolonOverlays.EidolonHearts());
        evt.registerBelow(VanillaGuiLayers.CHAT, Eidolon.prefix("mana_bar"), (LayeredDraw.Layer)new EidolonOverlays.EidolonManaBar());
        evt.registerAbove(VanillaGuiLayers.EXPERIENCE_BAR, Eidolon.prefix("raven_charge"), (LayeredDraw.Layer)new EidolonOverlays.EidolonRavenCharge());
    }

    public void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"consecration", (String)"holy_material", () -> "silver");
    }

    static {
        LOG = LogManager.getLogger((String)"Eidolon Repraised");
        trueMobType = false;
    }
}

