/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import elucent.eidolon.common.block.BlockBase;
import elucent.eidolon.registries.Registry;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EnchantedAshBlock
extends BlockBase {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape BARRIER_SHAPE = Shapes.m_83048_((double)0.0, (double)-4.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SIDE_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SIDE_TO_ASCENDING_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83110_((VoxelShape)SIDE_TO_SHAPE.get(Direction.NORTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.m_83110_((VoxelShape)SIDE_TO_SHAPE.get(Direction.SOUTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.m_83110_((VoxelShape)SIDE_TO_SHAPE.get(Direction.EAST), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.m_83110_((VoxelShape)SIDE_TO_SHAPE.get(Direction.WEST), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> stateToShapeMap = Maps.newHashMap();
    private final BlockState sideBaseState;

    public EnchantedAshBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE));
        this.sideBaseState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)RedstoneSide.SIDE)).m_61124_(EAST, (Comparable)RedstoneSide.SIDE)).m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE)).m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockstate : this.m_49965_().m_61056_()) {
            this.stateToShapeMap.put(blockstate, this.getShapeForState(blockstate));
        }
    }

    private VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelshape = BASE_SHAPE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SIDE_TO_SHAPE.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SIDE_TO_ASCENDING_SHAPE.get(direction));
        }
        return voxelshape;
    }

    private static boolean areAllSidesInvalid(BlockState state) {
        return !((RedstoneSide)state.m_61143_(NORTH)).m_61761_() && !((RedstoneSide)state.m_61143_(SOUTH)).m_61761_() && !((RedstoneSide)state.m_61143_(EAST)).m_61761_() && !((RedstoneSide)state.m_61143_(WEST)).m_61761_();
    }

    private static boolean areAllSidesValid(BlockState state) {
        return ((RedstoneSide)state.m_61143_(NORTH)).m_61761_() && ((RedstoneSide)state.m_61143_(SOUTH)).m_61761_() && ((RedstoneSide)state.m_61143_(EAST)).m_61761_() && ((RedstoneSide)state.m_61143_(WEST)).m_61761_();
    }

    private BlockState recalculateFacingState(BlockGetter reader, BlockState state, BlockPos pos) {
        boolean flag = !reader.m_8055_(pos.m_7494_()).m_60796_(reader, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.m_61143_((Property)FACING_PROPERTY_MAP.get(direction))).m_61761_()) continue;
            RedstoneSide redstoneside = this.recalculateSide(reader, pos, direction, flag);
            state = (BlockState)state.m_61124_((Property)FACING_PROPERTY_MAP.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    private RedstoneSide getSide(BlockGetter worldIn, BlockPos pos, Direction face) {
        return this.recalculateSide(worldIn, pos, face, !worldIn.m_8055_(pos.m_7494_()).m_60796_(worldIn, pos));
    }

    public void m_7742_(@NotNull BlockState state, @NotNull LevelAccessor worldIn, @NotNull BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.m_8055_((BlockPos)blockpos$mutable.m_122159_((Vec3i)pos, direction)).m_60713_((Block)this)) continue;
            blockpos$mutable.m_122173_(Direction.DOWN);
            BlockState blockstate = worldIn.m_8055_((BlockPos)blockpos$mutable);
            if (!blockstate.m_60713_(Blocks.f_50455_)) {
                BlockPos blockpos = blockpos$mutable.m_121945_(direction.m_122424_());
                BlockState blockstate1 = blockstate.m_60728_(direction.m_122424_(), worldIn.m_8055_(blockpos), worldIn, (BlockPos)blockpos$mutable, blockpos);
                EnchantedAshBlock.m_49908_((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)recursionLeft);
            }
            blockpos$mutable.m_122159_((Vec3i)pos, direction).m_122173_(Direction.UP);
            BlockState blockstate3 = worldIn.m_8055_((BlockPos)blockpos$mutable);
            if (blockstate3.m_60713_(Blocks.f_50455_)) continue;
            BlockPos blockpos1 = blockpos$mutable.m_121945_(direction.m_122424_());
            BlockState blockstate2 = blockstate3.m_60728_(direction.m_122424_(), worldIn.m_8055_(blockpos1), worldIn, (BlockPos)blockpos$mutable, blockpos1);
            EnchantedAshBlock.m_49908_((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)recursionLeft);
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return this.getUpdatedState((BlockGetter)worldIn, stateIn, currentPos);
        }
        RedstoneSide redstoneside = this.getSide((BlockGetter)worldIn, currentPos, facing);
        return redstoneside.m_61761_() == ((RedstoneSide)stateIn.m_61143_((Property)FACING_PROPERTY_MAP.get(facing))).m_61761_() && !EnchantedAshBlock.areAllSidesValid(stateIn) ? (BlockState)stateIn.m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside) : this.getUpdatedState((BlockGetter)worldIn, (BlockState)this.sideBaseState.m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside), currentPos);
    }

    private RedstoneSide recalculateSide(BlockGetter reader, BlockPos pos, Direction direction, boolean nonNormalCubeAbove) {
        boolean flag;
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = reader.m_8055_(blockpos);
        if (nonNormalCubeAbove && (flag = this.canPlaceOnTopOf(reader, blockpos, blockstate)) && EnchantedAshBlock.canConnectTo(reader.m_8055_(blockpos.m_7494_()), reader, blockpos.m_7494_(), null)) {
            if (blockstate.m_60783_(reader, blockpos, direction.m_122424_())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !EnchantedAshBlock.canConnectTo(blockstate, reader, blockpos, direction) && (blockstate.m_60796_(reader, blockpos) || !EnchantedAshBlock.canConnectTo(reader.m_8055_(blockpos.m_7495_()), reader, blockpos.m_7495_(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    private boolean canPlaceOnTopOf(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.m_60783_(reader, pos, Direction.UP);
    }

    private BlockState getUpdatedState(BlockGetter reader, BlockState state, BlockPos pos) {
        boolean flag = EnchantedAshBlock.areAllSidesInvalid(state);
        state = this.recalculateFacingState(reader, this.m_49966_(), pos);
        if (!flag || !EnchantedAshBlock.areAllSidesInvalid(state)) {
            boolean flag6;
            boolean flag1 = ((RedstoneSide)state.m_61143_(NORTH)).m_61761_();
            boolean flag2 = ((RedstoneSide)state.m_61143_(SOUTH)).m_61761_();
            boolean flag3 = ((RedstoneSide)state.m_61143_(EAST)).m_61761_();
            boolean flag4 = ((RedstoneSide)state.m_61143_(WEST)).m_61761_();
            boolean flag5 = !flag1 && !flag2;
            boolean bl = flag6 = !flag3 && !flag4;
            if (!flag4 && flag5) {
                state = (BlockState)state.m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag3 && flag5) {
                state = (BlockState)state.m_61124_(EAST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag1 && flag6) {
                state = (BlockState)state.m_61124_(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag2 && flag6) {
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getUpdatedState((BlockGetter)context.m_43725_(), this.sideBaseState, context.m_8083_());
    }

    public void m_6807_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && !worldIn.f_46443_) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
            this.updateNeighboursStateChange(worldIn, pos);
        }
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && ((living = (LivingEntity)entity).m_6336_() == MobType.f_21641_ || living.m_21222_());
    }

    boolean isBlocked(Entity entity) {
        LivingEntity living;
        if (entity == null) {
            return false;
        }
        if (entity instanceof LivingEntity && ((living = (LivingEntity)entity).m_6336_() == MobType.f_21641_ || living.m_21222_())) {
            return true;
        }
        return entity.m_20197_().stream().anyMatch(e -> {
            LivingEntity living;
            return e instanceof LivingEntity && ((living = (LivingEntity)e).m_6336_() == MobType.f_21641_ || living.m_21222_());
        });
    }

    @Override
    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return ctx instanceof EntityCollisionContext && ((EntityCollisionContext)ctx).m_193113_() != null && this.isBlocked(((EntityCollisionContext)ctx).m_193113_()) ? BARRIER_SHAPE : super.m_5939_(state, world, pos, ctx);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return this.canPlaceOnTopOf((BlockGetter)worldIn, blockpos, blockstate);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            if (!worldIn.f_46443_) {
                for (Direction direction : Direction.values()) {
                    worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                this.updateNeighboursStateChange(worldIn, pos);
            }
        }
    }

    private void updateChangedConnections(Level world, BlockPos pos, BlockState prevState, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (((RedstoneSide)prevState.m_61143_((Property)FACING_PROPERTY_MAP.get(direction))).m_61761_() == ((RedstoneSide)newState.m_61143_((Property)FACING_PROPERTY_MAP.get(direction))).m_61761_() || !world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) continue;
            world.m_46590_(blockpos, newState.m_60734_(), direction.m_122424_());
        }
    }

    private void notifyWireNeighborsOfStateChange(Level worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos).m_60713_((Block)this)) {
            worldIn.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    private void updateNeighboursStateChange(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.notifyWireNeighborsOfStateChange(world, pos.m_121945_(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction1);
            if (world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) {
                this.notifyWireNeighborsOfStateChange(world, blockpos.m_7494_());
                continue;
            }
            this.notifyWireNeighborsOfStateChange(world, blockpos.m_7495_());
        }
    }

    public void m_6861_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_ && !state.m_60710_((LevelReader)worldIn, pos)) {
            EnchantedAshBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.m_7471_(pos, false);
        }
    }

    protected static boolean canConnectTo(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        return blockState.m_60713_((Block)Registry.ENCHANTED_ASH.get());
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

