/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.Eidolon;
import elucent.eidolon.registries.DecoBlockPack;
import elucent.eidolon.registries.Registry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import org.jetbrains.annotations.NotNull;

public class EidRecipeProvider
extends RecipeProvider {
    private static int STONECUTTER_COUNTER = 0;

    public EidRecipeProvider(DataGenerator pGenerator) {
        super(pGenerator.getPackOutput());
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.ILLWOOD_PLANKS);
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.ELDER_BRICKS, List.of((Block)Registry.ELDER_BRICKS_EYE.get(), (Block)Registry.ELDER_PILLAR.get(), Registry.ELDER_MASONRY.getBlock()));
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.ELDER_MASONRY);
        EidRecipeProvider.makeStonecutter(pFinishedRecipeConsumer, (ItemLike)Blocks.f_50470_, (ItemLike)Registry.SMOOTH_STONE_MASONRY.getBlock(), "smooth_stone_masonry");
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.SMOOTH_STONE_MASONRY);
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.BONE_PILE);
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.POLISHED_PLANKS);
        EidRecipeProvider.makeStonecutter(pFinishedRecipeConsumer, (ItemLike)Registry.SMOOTH_STONE_BRICK.getBlock(), (ItemLike)Registry.SMOOTH_STONE_ARCH.get(), "smooth_stone_arch");
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Registry.MOSSY_SMOOTH_STONE_BRICKS.get())).m_126209_((ItemLike)Registry.SMOOTH_STONE_BRICK.getBlock()).m_126209_((ItemLike)Items.f_42029_).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Registry.SMOOTH_STONE_BRICK.getBlock()})).m_126140_(pFinishedRecipeConsumer, Eidolon.prefix("mossy_smooth_stone_bricks"));
        EidRecipeProvider.m_126002_(pFinishedRecipeConsumer, (ItemLike)((ItemLike)Registry.ILLWOOD_BARK.get()), (ItemLike)((ItemLike)Registry.ILLWOOD_LOG.get()));
        EidRecipeProvider.m_257929_(pFinishedRecipeConsumer, (ItemLike)Registry.ILLWOOD_PLANKS.getBlock(), Registry.ILLWOOD_LOGS, (int)4);
        EidRecipeProvider.strippedLogToWood(pFinishedRecipeConsumer, (ItemLike)Registry.STRIPPED_ILLWOOD_LOG.get(), (ItemLike)Registry.STRIPPED_ILLWOOD_BARK.get());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)Registry.SCRIPTORIUM.get()), (int)1).m_126130_("FSI").m_126130_("SSS").m_126130_("P P").m_126127_(Character.valueOf('F'), (ItemLike)Items.f_42402_).m_126127_(Character.valueOf('I'), (ItemLike)Registry.MAGIC_INK.get()).m_206416_(Character.valueOf('S'), ItemTags.f_13175_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126132_("has_parchment", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)Registry.PARCHMENT.get()})).m_176498_(pFinishedRecipeConsumer);
    }

    private void buildDecoPack(Consumer<FinishedRecipe> consumer, DecoBlockPack decoBlockPack, List<Block> extras) {
        Block block = decoBlockPack.getBlock();
        this.makeSlab(consumer, block, decoBlockPack.getSlab(), decoBlockPack.baseBlockName);
        this.makeStairs(consumer, block, decoBlockPack.getStairs(), decoBlockPack.baseBlockName);
        EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)decoBlockPack.getSlab(), 2, decoBlockPack.baseBlockName);
        EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)decoBlockPack.getStairs(), decoBlockPack.baseBlockName);
        if (decoBlockPack.getWall() != null) {
            this.makeWall(consumer, block, decoBlockPack.getWall(), decoBlockPack.baseBlockName);
            EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)decoBlockPack.getWall(), decoBlockPack.baseBlockName);
        }
        if (decoBlockPack.getPressurePlate() != null) {
            this.makePressurePlate(consumer, block, (Block)decoBlockPack.getPressurePlate(), decoBlockPack.baseBlockName);
        }
        if (decoBlockPack instanceof DecoBlockPack.WoodDecoBlock) {
            DecoBlockPack.WoodDecoBlock woodDecoBlock = (DecoBlockPack.WoodDecoBlock)decoBlockPack;
            if (woodDecoBlock.getFence() != null) {
                this.makeFence(consumer, block, woodDecoBlock.getFence(), decoBlockPack.baseBlockName);
                EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)woodDecoBlock.getFence(), decoBlockPack.baseBlockName);
            }
            if (woodDecoBlock.getFenceGate() != null) {
                this.makeGate(consumer, block, woodDecoBlock.getFenceGate(), decoBlockPack.baseBlockName);
                EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)woodDecoBlock.getFence(), decoBlockPack.baseBlockName);
            }
            if (woodDecoBlock.getButton() != null) {
                this.makeButton(consumer, block, woodDecoBlock.getButton(), decoBlockPack.baseBlockName);
            }
            if (woodDecoBlock.getStandingSign() != null) {
                EidRecipeProvider.makeSign(consumer, decoBlockPack, woodDecoBlock, block);
            }
            if (woodDecoBlock.getHangingSign() != null) {
                EidRecipeProvider.makeHSign(consumer, decoBlockPack, woodDecoBlock, block);
            }
        }
        for (Block extra : extras) {
            EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)extra, decoBlockPack.baseBlockName);
        }
        STONECUTTER_COUNTER = 0;
    }

    private static void makeSign(Consumer<FinishedRecipe> consumer, DecoBlockPack decoBlockPack, DecoBlockPack.WoodDecoBlock woodDecoBlock, Block block) {
        EidRecipeProvider.m_176726_((ItemLike)woodDecoBlock.getStandingSign(), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", decoBlockPack.baseBlockName + "_sign"));
    }

    private static void makeHSign(Consumer<FinishedRecipe> consumer, DecoBlockPack decoBlockPack, DecoBlockPack.WoodDecoBlock woodDecoBlock, Block block) {
        EidRecipeProvider.hSignBuilder((ItemLike)woodDecoBlock.getHangingSign(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", decoBlockPack.baseBlockName + "_hanging_sign"));
    }

    protected static RecipeBuilder hSignBuilder(ItemLike pSign, Ingredient pMaterial) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pSign, (int)6).m_126145_("hanging_sign").m_126124_(Character.valueOf('#'), pMaterial).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42026_).m_126130_("X X").m_126130_("###").m_126130_("###");
    }

    private void makeButton(Consumer<FinishedRecipe> consumer, Block block, ButtonBlock button, String baseBlockName) {
        EidRecipeProvider.m_176658_((ItemLike)button, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", baseBlockName + "_button"));
    }

    private void buildDecoPack(Consumer<FinishedRecipe> consumer, DecoBlockPack decoBlockPack) {
        this.buildDecoPack(consumer, decoBlockPack, List.of());
    }

    private void makeDoor(Consumer<FinishedRecipe> consumer, Block block, Block door, String basename) {
        EidRecipeProvider.m_176670_((ItemLike)door, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_door"));
    }

    private void makePressurePlate(Consumer<FinishedRecipe> consumer, Block block, Block pressurePlate, String basename) {
        EidRecipeProvider.m_247347_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)pressurePlate, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_pressure_plate"));
    }

    private void makeSlab(Consumer<FinishedRecipe> consumer, Block block, Block slab, String basename) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)slab, (int)6).m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)block).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_slab"));
    }

    private void makeWall(Consumer<FinishedRecipe> consumer, Block block, Block wall, String basename) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wall, (int)6).m_126130_("BBB").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)block).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_wall"));
    }

    private void makeStairs(Consumer<FinishedRecipe> consumer, Block block, Block stairs, String basename) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).m_126130_("B  ").m_126130_("BB ").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)block).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_stair"));
    }

    private void makeFence(Consumer<FinishedRecipe> consumer, Block block, Block fence, String basename) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).m_126130_("BSB").m_126130_("BSB").m_126127_(Character.valueOf('B'), (ItemLike)block).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_fence"));
    }

    private void makeGate(Consumer<FinishedRecipe> consumer, Block block, Block gate, String basename) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)gate, (int)1).m_126130_("SBS").m_126130_("SBS").m_126127_(Character.valueOf('B'), (ItemLike)block).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, new ResourceLocation("eidolon", basename + "_gate"));
    }

    public static void makeStonecutter(Consumer<FinishedRecipe> consumer, ItemLike input, ItemLike output, String reg) {
        EidRecipeProvider.makeStonecutter(consumer, input, output, 1, reg);
    }

    public static void makeStonecutter(Consumer<FinishedRecipe> consumer, ItemLike input, ItemLike output, int quantity, String reg) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)quantity).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, new ResourceLocation("eidolon", reg + "_stonecutter_" + STONECUTTER_COUNTER));
        ++STONECUTTER_COUNTER;
    }

    private static void strippedLogToWood(Consumer<FinishedRecipe> recipeConsumer, ItemLike stripped, ItemLike output) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).m_126127_(Character.valueOf('#'), stripped).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_illwood", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{stripped})).m_176498_(recipeConsumer);
    }
}

