/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.DarkTouchSpell;
import elucent.eidolon.recipe.ChantConversionRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LightTouchSpell
extends DarkTouchSpell {
    public static final String SACRED_KEY = new ResourceLocation("eidolon", "sacred").toString();

    public LightTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, signs);
        MinecraftForge.EVENT_BUS.addListener(LightTouchSpell::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            CompoundTag tag;
            Mob mob;
            LivingEntity caster = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof Mob && (mob = (Mob)entity).m_6336_() == MobType.f_21641_ && (tag = caster.m_21205_().m_41783_()) != null && tag.m_128441_(SACRED_KEY)) {
                event.setAmount(event.getAmount() * 1.5f);
                tag.m_128405_(SACRED_KEY, tag.m_128451_(SACRED_KEY) - 1);
                if (tag.m_128451_(SACRED_KEY) <= 0) {
                    tag.m_128473_(SACRED_KEY);
                }
            }
        }
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        if (!world.getCapability(IReputation.INSTANCE).isPresent()) {
            return false;
        }
        if (((IReputation)world.getCapability(IReputation.INSTANCE).resolve().get()).getReputation(player, Deities.LIGHT_DEITY.getId()) < 10.0) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.not_enough_reputation"), true);
            return false;
        }
        Vec3 v = LightTouchSpell.getVector(world, player);
        List items = world.m_45976_(ItemEntity.class, new AABB(v.f_82479_ - 1.5, v.f_82480_ - 1.5, v.f_82481_ - 1.5, v.f_82479_ + 1.5, v.f_82480_ + 1.5, v.f_82481_ + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.get(0)).m_32055_();
        return this.canTouch(stack, world, player);
    }

    @Override
    boolean canTouch(ItemStack stack, Level world, Player player) {
        if (stack.m_41763_() && stack.m_41741_() == 1) {
            return true;
        }
        List conversions = world.m_7465_().m_44013_((RecipeType)EidolonRecipes.CHANT_CONVERSION_TYPE.get());
        double lightRep = ((IReputation)world.getCapability(IReputation.INSTANCE).resolve().get()).getReputation(player, Deities.LIGHT_DEITY_ID);
        return conversions.stream().filter(r -> r.input.test(stack) && (r.deity == null || Deities.LIGHT_DEITY_ID.equals((Object)r.deity))).anyMatch(r -> lightRep >= (double)r.minDevotion);
    }

    @Override
    protected ItemStack touchResult(ItemStack stack, Player player) {
        double lightRep = ((IReputation)player.m_9236_().getCapability(IReputation.INSTANCE).resolve().get()).getReputation(player, Deities.LIGHT_DEITY_ID);
        ISoul mana = player.getCapability(ISoul.INSTANCE).resolve().orElse(null);
        if (mana == null) {
            return stack;
        }
        for (ChantConversionRecipe r : player.m_9236_().m_7465_().m_44013_((RecipeType)EidolonRecipes.CHANT_CONVERSION_TYPE.get())) {
            int maxConversionCount;
            if (!r.input.test(stack) || r.deity != null && !Deities.LIGHT_DEITY_ID.equals((Object)r.deity) || !(lightRep >= (double)r.minDevotion)) continue;
            float conversionCost = r.conversionCost >= 0.0f ? r.conversionCost : (float)this.getCost();
            int n = maxConversionCount = conversionCost != 0.0f ? (int)Math.min((float)stack.m_41613_(), mana.getMagic() / conversionCost) : stack.m_41613_();
            if (maxConversionCount <= 0) continue;
            ISoul.expendMana(player, (int)(conversionCost * (float)maxConversionCount));
            ItemStack result = r.m_8043_(player.m_9236_().m_9598_());
            result.m_41764_(maxConversionCount);
            return result;
        }
        if (stack.m_41763_() && stack.m_41741_() == 1) {
            ISoul.expendMana(player, this.getCost());
            stack.m_41784_().m_128405_(SACRED_KEY, 50);
        }
        return stack;
    }
}

