/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.block;

import elucent.eidolon.common.block.BlockBase;
import elucent.eidolon.common.tile.CrucibleTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class CrucibleBlock
extends BlockBase
implements EntityBlock,
LiquidBlockContainer {
    public CrucibleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrucibleTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, tile) -> ((CrucibleTileEntity)tile).tick();
    }

    public boolean m_6044_(@NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Fluid pFluid) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CrucibleTileEntity) {
            CrucibleTileEntity crucibleTileEntity = (CrucibleTileEntity)blockEntity;
            return !crucibleTileEntity.hasWater && pFluid.m_6212_((Fluid)Fluids.f_76193_);
        }
        return false;
    }

    public boolean m_7361_(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull FluidState pFluidState) {
        BlockEntity blockEntity;
        if (!pLevel.m_5776_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof CrucibleTileEntity) {
            CrucibleTileEntity crucibleTileEntity = (CrucibleTileEntity)blockEntity;
            if (pFluidState.m_76170_() && pFluidState.m_192917_((Fluid)Fluids.f_76193_)) {
                crucibleTileEntity.fill();
                crucibleTileEntity.sync();
                pLevel.m_5594_(null, pPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrucibleTileEntity) {
            CrucibleTileEntity crucibleTileEntity = (CrucibleTileEntity)blockEntity;
            if (level.m_276867_(pos) && crucibleTileEntity.getStirTicks() == 0 && !crucibleTileEntity.getSteps().isEmpty()) {
                crucibleTileEntity.stir(pos);
            }
        }
    }
}

