/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.Eidolon;
import elucent.eidolon.api.ritual.FocusItemRequirement;
import elucent.eidolon.api.ritual.HealthRequirement;
import elucent.eidolon.api.ritual.ItemRequirement;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public abstract class RitualRecipe
implements Recipe<BrazierTileEntity> {
    public Ingredient reagent;
    public List<Ingredient> pedestalItems;
    public List<Ingredient> focusItems;
    public List<Ingredient> invariantItems = new ArrayList<Ingredient>(2);
    public ResourceLocation id;
    float healthRequirement = 0.0f;

    public RitualRecipe(ResourceLocation id, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, List<Ingredient> invariantItems, float healthRequirement) {
        this(id, reagent, pedestalItems, focusItems, healthRequirement);
        this.invariantItems = invariantItems;
    }

    public RitualRecipe(ResourceLocation id, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems) {
        this.reagent = reagent;
        this.pedestalItems = pedestalItems;
        this.focusItems = focusItems;
        this.id = id;
    }

    public RitualRecipe(ResourceLocation id, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, float healthRequirement) {
        this(id, reagent, pedestalItems, focusItems);
        this.healthRequirement = healthRequirement;
    }

    public RitualRecipe() {
        this.reagent = Ingredient.f_43901_;
        this.pedestalItems = new ArrayList<Ingredient>();
        this.focusItems = new ArrayList<Ingredient>();
        this.id = Eidolon.prefix("empty");
    }

    static List<Ingredient> getPedestalItems(JsonArray pedestalJson) {
        return StreamSupport.stream(pedestalJson.spliterator(), true).map(Ingredient::m_43917_).collect(Collectors.toList());
    }

    public static void addRitualElements(RitualRecipe RitualRecipe2, JsonObject jsonobject) {
        JsonArray reagent = new JsonArray();
        reagent.add(RitualRecipe2.reagent.m_43942_());
        jsonobject.add("reagent", (JsonElement)reagent);
        if (RitualRecipe2.healthRequirement > 0.0f) {
            jsonobject.addProperty("healthRequirement", (Number)Float.valueOf(RitualRecipe2.healthRequirement));
        }
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient ingredient : RitualRecipe2.pedestalItems) {
            pedestalArr.add(ingredient.m_43942_());
        }
        jsonobject.add("pedestalItems", (JsonElement)pedestalArr);
        JsonArray focusArr = new JsonArray();
        for (Ingredient i : RitualRecipe2.focusItems) {
            focusArr.add(i.m_43942_());
        }
        jsonobject.add("focusItems", (JsonElement)focusArr);
        if (!RitualRecipe2.invariantItems.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (Ingredient i : RitualRecipe2.invariantItems) {
                jsonArray.add(i.m_43942_());
            }
            jsonobject.add("invariantItems", (JsonElement)jsonArray);
        }
    }

    public boolean excludeJei() {
        return false;
    }

    public boolean isMatch(List<ItemStack> pedestalItems, List<ItemStack> focusItems, ItemStack reagent) {
        return this.doesReagentMatch(reagent) && this.pedestalItems.size() == pedestalItems.size() && RitualRecipe.doItemsMatch(pedestalItems, this.pedestalItems) && this.focusItems.size() == focusItems.size() && RitualRecipe.doItemsMatch(focusItems, this.focusItems);
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return this.reagent.test(reag);
    }

    public static boolean doItemsMatch(List<ItemStack> inputs, List<Ingredient> recipeItems) {
        StackedContents recipeitemhelper = new StackedContents();
        for (ItemStack i : inputs) {
            recipeitemhelper.m_36468_(i, 1);
        }
        return inputs.size() == recipeItems.size() && RecipeMatcher.findMatches(inputs, recipeItems) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RitualRecipe that = (RitualRecipe)o;
        return Objects.equals(this.reagent, that.reagent) && Objects.equals(this.pedestalItems, that.pedestalItems) && Objects.equals(this.focusItems, that.focusItems);
    }

    public int hashCode() {
        return Objects.hash(this.reagent, this.pedestalItems, this.focusItems);
    }

    public String toString() {
        return "RitualBrazierRecipe{" + this.id + "catalyst=" + this.reagent + ", pedestalItems=" + this.pedestalItems + ", focusItems=" + this.focusItems + "}";
    }

    public abstract Ritual getRitual();

    public Ritual getRitualWithRequirements() {
        Ritual ritual = this.getRitual().clone().addRequirements(this.pedestalItems.stream().map(ItemRequirement::new).collect(Collectors.toList()));
        if (!this.focusItems.isEmpty()) {
            ritual.addRequirements(this.focusItems.stream().map(FocusItemRequirement::new).collect(Collectors.toList()));
        }
        if (this.healthRequirement > 0.0f) {
            ritual.addRequirement(new HealthRequirement(this.healthRequirement));
        }
        ritual.sortRequirements();
        return ritual;
    }

    public abstract JsonElement asRecipe();

    public boolean matches(@NotNull BrazierTileEntity tile, @NotNull Level worldIn) {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> focusItems = new ArrayList<ItemStack>();
        tile.providePedestalItems(pedestalItems, focusItems);
        return this.isMatch(pedestalItems, focusItems, tile.getStack());
    }

    @NotNull
    public ItemStack assemble(@NotNull BrazierTileEntity inv, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static abstract class Serializer<T extends RitualRecipe>
    implements RecipeSerializer<T> {
        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.writeInt(((RitualRecipe)recipe).pedestalItems.size());
            buf.writeInt(((RitualRecipe)recipe).focusItems.size());
            ((RitualRecipe)recipe).reagent.m_43923_(buf);
            for (Ingredient i : ((RitualRecipe)recipe).pedestalItems) {
                i.m_43923_(buf);
            }
            for (Ingredient i : ((RitualRecipe)recipe).focusItems) {
                i.m_43923_(buf);
            }
            buf.writeFloat(((RitualRecipe)recipe).healthRequirement);
        }
    }
}

