/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import java.util.function.Supplier;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class GenericParticlePacket {
    private final double x;
    private final double y;
    private final double z;
    private final double xSpeed;
    private final double ySpeed;
    private final double zSpeed;
    private final ParticleOptions particle;

    public GenericParticlePacket(double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleOptions particle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
        this.particle = particle;
    }

    public static GenericParticlePacket decode(FriendlyByteBuf pBuffer) {
        ParticleType particletype = (ParticleType)pBuffer.m_236816_((IdMap)BuiltInRegistries.f_257034_);
        double x = pBuffer.readDouble();
        double y = pBuffer.readDouble();
        double z = pBuffer.readDouble();
        double xSpeed = pBuffer.readDouble();
        double ySpeed = pBuffer.readDouble();
        double zSpeed = pBuffer.readDouble();
        Object particle = GenericParticlePacket.readParticle(pBuffer, particletype);
        return new GenericParticlePacket(x, y, z, xSpeed, ySpeed, zSpeed, (ParticleOptions)particle);
    }

    private static <T extends ParticleOptions> T readParticle(FriendlyByteBuf pBuffer, ParticleType<T> pParticleType) {
        return (T)pParticleType.m_123743_().m_6507_(pParticleType, pBuffer);
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)this.particle.m_6012_());
        pBuffer.writeDouble(this.x);
        pBuffer.writeDouble(this.y);
        pBuffer.writeDouble(this.z);
        pBuffer.writeDouble(this.xSpeed);
        pBuffer.writeDouble(this.ySpeed);
        pBuffer.writeDouble(this.zSpeed);
        this.particle.m_7711_(pBuffer);
    }

    public static void consume(GenericParticlePacket packet, Supplier<NetworkEvent.Context> pContext) {
        pContext.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)pContext.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (world = Eidolon.proxy.getWorld()) != null) {
                world.m_7106_(packet.particle, packet.x, packet.y, packet.z, packet.xSpeed, packet.ySpeed, packet.zSpeed);
            }
        });
        pContext.get().setPacketHandled(true);
    }
}

