/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.registries.DecoBlockPack;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;

public class ModLootTables
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public ModLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn.getPackOutput(), new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.f_81421_)));
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public final List<Block> list = new ArrayList<Block>();
        private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        protected BlockLootTable() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_(), new HashMap());
        }

        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> p_249322_) {
            this.m_245660_();
            HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceLocation resourcelocation;
                if (!block.m_245993_(this.f_243739_) || (resourcelocation = block.m_60589_()) == BuiltInLootTables.f_78712_ || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.f_244441_.remove(resourcelocation)) == null) continue;
                p_249322_.accept(resourcelocation, loottable$builder);
            }
        }

        protected void m_245660_() {
            this.registerLeavesAndSticks((Block)Registry.ILLWOOD_LEAVES.get(), (Block)Registry.ILLWOOD_SAPLING.get());
            this.registerDropSelf((Block)Registry.ILLWOOD_SAPLING.get());
            this.registerDropSelf((Block)Registry.ILLWOOD_LOG.get());
            this.registerDropSelf((Block)Registry.ILLWOOD_BARK.get());
            this.registerDropSelf((Block)Registry.STRIPPED_ILLWOOD_LOG.get());
            this.registerDropSelf((Block)Registry.STRIPPED_ILLWOOD_BARK.get());
            this.registerDropSelf(Registry.ILLWOOD_PLANKS);
            this.registerDropSelf(Registry.ELDER_BRICKS);
            this.registerDropSelf(Registry.ELDER_MASONRY);
            this.registerDropSelf(Registry.SMOOTH_STONE_MASONRY);
            this.registerDropSelf(Registry.BONE_PILE);
            this.registerDropSelf((Block)Registry.ELDER_PILLAR.get());
            this.registerDropSelf((Block)Registry.ELDER_BRICKS_EYE.get());
            this.registerDropSelf((Block)Registry.SMOOTH_STONE_ARCH.get());
            this.registerDropSelf((Block)Registry.MOSSY_SMOOTH_STONE_BRICKS.get());
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.m_245724_(block);
        }

        public void registerDropSelf(DecoBlockPack blockpack) {
            ArrayList<Object> blocks = new ArrayList<Object>();
            blocks.add(blockpack.getBlock());
            blocks.add(blockpack.getSlab());
            blocks.add(blockpack.getStairs());
            blocks.add(blockpack.getWall());
            if (blockpack instanceof DecoBlockPack.WoodDecoBlock) {
                DecoBlockPack.WoodDecoBlock woodDecoBlock = (DecoBlockPack.WoodDecoBlock)blockpack;
                blocks.add(woodDecoBlock.getFence());
                blocks.add(woodDecoBlock.getFenceGate());
                blocks.add(woodDecoBlock.getButton());
                blocks.add(woodDecoBlock.getPressurePlate());
                blocks.add(woodDecoBlock.getStandingSign());
                blocks.add(woodDecoBlock.getWallSign());
                blocks.add(woodDecoBlock.getHangingSign());
                blocks.add(woodDecoBlock.getHangingWallSign());
            }
            for (Block block : blocks) {
                if (block == null) continue;
                this.list.add(block);
                this.m_245724_(block);
            }
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.m_246481_(leaves, l_state -> this.m_246047_((Block)l_state, sapling, DEFAULT_SAPLING_DROP_RATES));
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

