/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.research.ResearchTask;
import elucent.eidolon.common.tile.TileEntityBase;
import elucent.eidolon.gui.ResearchTableContainer;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Researches;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ResearchTableTileEntity
extends TileEntityBase
implements WorldlyContainer,
MenuProvider {
    private static final int[] SLOTS = new int[]{0, 1};
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ResearchTask> tasks = NonNullList.m_122779_();
    private Component name;
    private int progress = 0;
    private int worldSeed;
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    public static final int SEED = 1418644859;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ResearchTableTileEntity.this.progress;
                case 1 -> ResearchTableTileEntity.this.worldSeed;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ResearchTableTileEntity.this.progress = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    final LazyOptional<? extends IItemHandler> handler = LazyOptional.of(() -> new InvWrapper((Container)this));

    public ResearchTableTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.RESEARCH_TABLE_TILE_ENTITY.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.worldSeed = 1418644859 + 978060631 * (int)((ServerLevel)this.f_58857_).m_7328_();
        }
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.eidolon.research_table");
    }

    public void addListener(ContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
    }

    public void tick() {
        if (this.progress < 0) {
            this.progress = 0;
            this.sync();
        }
        if (this.progress > 0) {
            if (((ItemStack)this.stacks.get(0)).m_41619_() || ((ItemStack)this.stacks.get(0)).m_41720_() != Registry.RESEARCH_NOTES.get()) {
                this.progress = 0;
                this.sync();
                for (ContainerListener listener : this.listeners) {
                    listener.m_142153_((AbstractContainerMenu)listener, 0, this.progress);
                }
                return;
            }
            --this.progress;
            if (this.progress == 0) {
                ItemStack notes = (ItemStack)this.stacks.get(0);
                CompoundTag notesTag = notes.m_41783_();
                Research r = Researches.find(new ResourceLocation(notesTag.m_128461_("research")));
                int done = notesTag.m_128451_("stepsDone");
                notesTag.m_128405_("stepsDone", ++done);
                for (ContainerListener listener : this.listeners) {
                    listener.m_7934_((AbstractContainerMenu)listener, 0, (ItemStack)this.stacks.get(0));
                }
            }
            this.sync();
            for (ContainerListener listener : this.listeners) {
                listener.m_142153_((AbstractContainerMenu)listener, 0, this.progress);
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.stacks);
        this.progress = nbt.m_128451_("progress");
        this.worldSeed = nbt.m_128451_("worldSeed");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("progress", this.progress);
        compound.m_128405_("worldSeed", this.worldSeed);
        ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.stacks.size() ? (ItemStack)this.stacks.get(index) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.stacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.stacks, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.stacks.size()) {
            this.stacks.set(index, (Object)stack);
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (player.f_19853_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        if (index == 0) {
            return stack.m_150930_((Item)Registry.RESEARCH_NOTES.get());
        }
        if (index == 1) {
            return stack.m_150930_((Item)Registry.ARCANE_SEAL.get());
        }
        return false;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (index == 0) {
            return stack.m_150930_((Item)Registry.COMPLETED_RESEARCH.get());
        }
        return false;
    }

    public void m_6211_() {
        this.stacks.clear();
    }

    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ResearchTableContainer(id, inv, (Container)this, this.dataAccess);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }
}

