/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.deity;

import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.common.deity.DarkDeity;
import elucent.eidolon.common.deity.LightDeity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class Deities {
    static final Map<ResourceLocation, Deity> deities = new HashMap<ResourceLocation, Deity>();
    public static final ResourceLocation DARK_DEITY_ID = new ResourceLocation("eidolon", "dark");
    public static final ResourceLocation LIGHT_DEITY_ID = new ResourceLocation("eidolon", "light");
    public static final Deity DARK_DEITY = Deities.register(new DarkDeity(DARK_DEITY_ID, 154, 77, 255));
    public static final Deity LIGHT_DEITY = Deities.register(new LightDeity(LIGHT_DEITY_ID, 255, 230, 117));

    public static Deity register(Deity deity) {
        deities.put(deity.getId(), deity);
        return deity;
    }

    public static Deity find(ResourceLocation deity) {
        return deities.getOrDefault(deity, null);
    }

    public static List<Deity> getDeities() {
        return new ArrayList<Deity>(deities.values());
    }
}

