/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.Eidolon;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.recipe.ChantRecipe;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChantPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_chant_page.png");
    protected Sign[] chant;
    final String text;
    final String title;
    final Spell spell;

    public ChantPage(String textKey, Spell spell) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = textKey + ".title";
        this.spell = spell;
    }

    @Override
    public void fullRender(CodexGui gui, GuiGraphics mStack, int x, int y, int mouseX, int mouseY) {
        Object var8_7;
        if (this.spell != null && this.chant == null && (var8_7 = Eidolon.proxy.getWorld().m_7465_().m_44043_(this.spell.getRegistryName()).orElse(null)) instanceof ChantRecipe) {
            ChantRecipe chantRecipe = var8_7;
            this.chant = chantRecipe.signs();
            if (this.chant == null || this.chant.length == 0) {
                mStack.m_280488_(gui.getMinecraft().f_91062_, "No matching recipe found for " + this.spell.getRegistryName(), x + 10, y + 10, 0);
            }
        }
        super.fullRender(gui, mStack, x, y, mouseX, mouseY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        String title = I18n.m_118938_((String)this.title, (Object[])new Object[0]);
        int titleWidth = Minecraft.m_91087_().f_91062_.m_92895_(title);
        PoseStack mStack = guiGraphics.m_280168_();
        int n = x + 64 - titleWidth / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        ChantPage.drawText(guiGraphics, title, n, y + 15 - 9);
        if (this.chant != null) {
            int w = this.chant.length * 24;
            int baseX = x + 64 - w / 2;
            CodexGui.blit(guiGraphics, baseX - 16, y + 28, 256.0f, 208.0f, 16, 32, 512, 512);
            for (int i = 0; i < this.chant.length; ++i) {
                CodexGui.blit(guiGraphics, baseX + i * 24, y + 28, 272.0f, 208.0f, 24, 32, 512, 512);
            }
            CodexGui.blit(guiGraphics, baseX + w, y + 28, 296.0f, 208.0f, 16, 32, 512, 512);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderSystem.enableBlend();
            for (int i = 0; i < this.chant.length; ++i) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                CodexGui.blit(guiGraphics, baseX + i * 24, y + 28, 312.0f, 208.0f, 24, 24, 512, 512);
                Sign sign = this.chant[i];
                float flicker = 0.875f + 0.125f * (float)Math.sin(Math.toRadians(12.0f * ClientInfo.getClientPartialTicks()));
                RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, baseX + i * 24 + 4, y + 32, 16.0, 16.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(sign.getSprite()));
                RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, baseX + i * 24 + 4, y + 32, 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(sign.getSprite()));
            }
            bufferSource.m_109911_();
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        ChantPage.drawWrappingText(guiGraphics, I18n.m_118938_((String)this.text, (Object[])new Object[0]), x + 4, y + 72, 120);
    }
}

