/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.common.tile.IBurner;
import elucent.eidolon.network.IgniteEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.Researches;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FireTouchSpell
extends StaticSpell {
    public FireTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, 10, 5, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos blockPos, Player player) {
        if (!KnowledgeUtil.knowsResearch(player, Researches.FIRE_SPELL.getRegistryName())) {
            return false;
        }
        HitResult ray = FireTouchSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
        if (ray instanceof BlockHitResult) {
            BlockHitResult rayTraceResult = (BlockHitResult)ray;
            BlockState hitState = world.m_8055_(rayTraceResult.m_82425_());
            if (hitState.m_60734_() instanceof CandleBlock && CandleBlock.m_152845_((BlockState)hitState) || hitState.m_60734_() instanceof CampfireBlock && CampfireBlock.m_51321_((BlockState)hitState)) {
                return true;
            }
            BlockEntity blockEntity = world.m_7702_(rayTraceResult.m_82425_());
            if (blockEntity instanceof IBurner) {
                IBurner brazier = (IBurner)blockEntity;
                return brazier.canStartBurning();
            }
        }
        return ray instanceof EntityHitResult;
    }

    @Override
    public void cast(Level world, BlockPos blockPos, Player player) {
        if (!world.f_46443_) {
            HitResult ray = FireTouchSpell.rayTrace((Entity)player, player.getBlockReach(), 0.0f, true);
            if (ray instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)ray;
                BlockState hitState = world.m_8055_(blockHitResult.m_82425_());
                if (hitState.m_60734_() instanceof CandleBlock && CandleBlock.m_152845_((BlockState)hitState) || hitState.m_60734_() instanceof CampfireBlock && CampfireBlock.m_51321_((BlockState)hitState)) {
                    world.m_7731_(blockHitResult.m_82425_(), (BlockState)hitState.m_61124_((Property)AbstractCandleBlock.f_151895_, (Comparable)Boolean.TRUE), 11);
                    Networking.sendToTracking(world, blockHitResult.m_82425_(), new IgniteEffectPacket(blockHitResult.m_82425_(), 1.0f, 0.5f, 0.25f));
                } else {
                    BlockEntity blockEntity = world.m_7702_(blockHitResult.m_82425_());
                    if (blockEntity instanceof IBurner) {
                        IBurner brazier = (IBurner)blockEntity;
                        brazier.startBurning(player, world, blockHitResult.m_82425_());
                    }
                }
                world.m_5594_(player, blockPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
            } else if (ray instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)ray;
                entityHitResult.m_82443_().m_20254_(10);
            } else {
                return;
            }
            ISoul.expendMana(player, this.getCost());
        }
    }
}

