/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.incense;

import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.ritual.IncenseRitual;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.tile.CenserTileEntity;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.registries.Spells;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PrayerIncense
extends IncenseRitual {
    public PrayerIncense(ResourceLocation registryName) {
        super(800, registryName);
    }

    @Override
    public boolean start(@Nullable Player player, CenserTileEntity censer) {
        super.start(player, censer);
        Level world = censer.m_58904_();
        BlockPos pos = censer.m_58899_();
        if (world == null || player == null) {
            return false;
        }
        LazyOptional reputationLazyOptional = world.getCapability(IReputation.INSTANCE);
        if (!reputationLazyOptional.isPresent() || reputationLazyOptional.resolve().isEmpty()) {
            return false;
        }
        if (!((IReputation)reputationLazyOptional.resolve().get()).canPray(player, Spells.CENSER, world.m_46467_())) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.prayer_cooldown"), true);
            return false;
        }
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AABB(pos.m_7918_(-4, -4, -4), pos.m_7918_(5, 5, 5)));
        if (effigies.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.no_effigy"), true);
            return false;
        }
        EffigyTileEntity effigy = effigies.stream().min(Comparator.comparingDouble(e -> e.m_58899_().m_123331_((Vec3i)pos))).get();
        if (effigy.ready()) {
            Deity deity = Deities.LIGHT_DEITY;
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                if (rep.getReputation(player, deity.getId()) < 3.0) {
                    player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.not_enough_reputation"), true);
                    return;
                }
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.BASIC_INCENSE_PRAYER);
                rep.pray(player, Spells.CENSER, world.m_46467_());
                rep.addReputation(player, deity.getId(), 2.0 + 0.5 * info.getPower());
                PrayerSpell.updateMagic(info, player, world, rep.getReputation(player, deity.getId()));
            });
            return true;
        }
        return false;
    }
}

