/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.incense;

import elucent.eidolon.api.ritual.IncenseRitual;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.tile.CenserTileEntity;
import elucent.eidolon.registries.EidolonParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GloomIncense
extends IncenseRitual {
    public GloomIncense(ResourceLocation registryName) {
        super(800, registryName);
    }

    @Override
    public float getRed() {
        return 0.5f;
    }

    @Override
    public float getBlue() {
        return 1.0f;
    }

    @Override
    public void animateParticles(CenserTileEntity censer, int burnCounter) {
        super.animateParticles(censer, burnCounter);
        Level level = censer.m_58904_();
        BlockPos pos = censer.m_58899_();
        assert (level != null);
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        if (level.f_46441_.m_188503_(2) == 0) {
            Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.35f, 0.0f).setScale(0.375f, 0.125f).setLifetime(280).randomOffset(10.0, 0.5).randomVelocity(0.025f, 0.025f).addVelocity(0.0, -0.0125f, 0.0).setColor(0.125f, 0.125f, 0.125f, 0.005f, 0.005f, 0.005f).repeat(level, x, y + 0.125, z, 5);
        }
    }

    @Override
    public void tickEffect(int age) {
        if (age % 20 == 0) {
            Level level = this.censer.m_58904_();
            BlockPos pos = this.censer.m_58899_();
            assert (level != null);
            for (LivingEntity entity : level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(10.0))) {
                if (entity.m_6336_() != MobType.f_21641_) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
                    continue;
                }
                entity.m_5634_(1.0f);
            }
        }
    }
}

