/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.ritual;

import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.tile.CenserTileEntity;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.IncenseRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class IncenseRitual {
    protected CenserTileEntity censer;
    protected Player player;
    protected ResourceLocation registryName;
    int maxDuration;

    public IncenseRitual(int maxDuration, ResourceLocation registryName) {
        this.maxDuration = maxDuration;
        this.registryName = registryName;
    }

    public boolean start(@Nullable Player player, CenserTileEntity censer) {
        this.censer = censer;
        this.player = player;
        return true;
    }

    public void tick(int age) {
        if (this.censer != null) {
            if (age < this.maxDuration) {
                this.tickEffect(age);
            } else {
                this.censer.extinguish();
            }
        }
    }

    public void tickEffect(int age) {
    }

    public void write(CompoundTag tag) {
        CompoundTag contextTag = new CompoundTag();
        if (this.registryName != null) {
            contextTag.m_128359_("incenseRegistryName", this.registryName.toString());
        }
        tag.m_128365_("incenseContext", (Tag)contextTag);
    }

    public static IncenseRitual read(CompoundTag tag) {
        CompoundTag contextTag = tag.m_128469_("incenseContext");
        ResourceLocation incenseRegistryName = ResourceLocation.m_135820_((String)contextTag.m_128461_("incenseRegistryName"));
        return IncenseRegistry.getIncenseRitual(incenseRegistryName);
    }

    public float getRed() {
        return 1.0f;
    }

    public float getGreen() {
        return 0.5f;
    }

    public float getBlue() {
        return 0.3f;
    }

    public void animateParticles(CenserTileEntity censer, int burnCounter) {
        BlockPos pos = censer.m_58899_();
        Level level = censer.m_58904_();
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 0.45f;
        float z = (float)pos.m_123343_() + 0.5f;
        float r = this.getRed();
        float g = this.getGreen();
        float b = this.getBlue();
        if (burnCounter < 160) {
            Particles.create(EidolonParticles.FLAME_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.25f, 0.125f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(level, x, y, z);
        }
        assert (level != null);
        if (level.f_46441_.m_188503_(20) == 0) {
            Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(level, x, y, z);
        }
        if (level.f_46441_.m_188503_(5) == 0) {
            Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.125f).setLifetime(160).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.0125f, 0.0).setColor(0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(level, x, (double)y + 0.125, z);
        }
    }
}

