/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeUtil {
    public static RecipeManager getRecipeManager() {
        return (RecipeManager)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().m_91403_().m_105141_(), () -> () -> ServerLifecycleHooks.getCurrentServer().m_129894_());
    }

    public static Ingredient ingredientFromObject(Object object) {
        if (object instanceof Item) {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(Item)object});
        }
        if (object instanceof Block) {
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)((Block)object))});
        }
        if (object instanceof ItemStack) {
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)object});
        }
        if (object instanceof TagKey) {
            return Ingredient.m_204132_((TagKey)((TagKey)object));
        }
        return Ingredient.f_43901_;
    }

    public static List<Ingredient> ingredientsFromObjects(List<Object> objects) {
        return objects.stream().map(RecipeUtil::ingredientFromObject).collect(Collectors.toList());
    }

    public static ItemStack stackFromObject(Object object) {
        if (object instanceof Item) {
            return new ItemStack((ItemLike)((Item)object));
        }
        if (object instanceof Block) {
            return new ItemStack((ItemLike)((Block)object));
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> stacksFromObjects(List<Object> objects) {
        return objects.stream().map(RecipeUtil::stackFromObject).collect(Collectors.toList());
    }

    public static NonNullList<Ingredient> parseShapeless(JsonObject json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (boolean)true));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        return ingredients;
    }
}

