/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.registries.Registry;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class DecoBlockPack {
    final DeferredRegister<Block> mainBlock;
    public final String baseBlockName;
    final BlockBehaviour.Properties props;
    RegistryObject<Block> full;
    RegistryObject<Block> slab;
    RegistryObject<Block> stair;
    @Nullable
    RegistryObject<Block> wall = null;
    @Nullable
    RegistryObject<Block> pressure_plate = null;

    public DecoBlockPack(DeferredRegister<Block> blocks, String baseBlockName, BlockBehaviour.Properties props) {
        this.mainBlock = blocks;
        this.baseBlockName = baseBlockName;
        this.props = props;
        this.full = Registry.addBlock(baseBlockName, () -> new Block(props));
        this.slab = Registry.addBlock(baseBlockName + "_slab", () -> new SlabBlock(props));
        this.stair = Registry.addBlock(baseBlockName + "_stairs", () -> new StairBlock(() -> ((Block)this.full.get()).m_49966_(), props));
    }

    public DecoBlockPack addWall() {
        this.wall = Registry.addBlock(this.baseBlockName + "_wall", () -> new WallBlock(this.props));
        return this;
    }

    public DecoBlockPack addPressurePlate(PressurePlateBlock.Sensitivity sensitivity) {
        this.pressure_plate = Registry.addBlock(this.baseBlockName + "_pressure_plate", () -> new PressurePlateBlock(sensitivity, this.props, BlockSetType.f_271528_));
        return this;
    }

    public Block getBlock() {
        return (Block)this.full.get();
    }

    public Block getSlab() {
        return (Block)this.slab.get();
    }

    public Block getStairs() {
        return (Block)this.stair.get();
    }

    public Block getWall() {
        return this.wall == null ? null : (Block)this.wall.get();
    }

    @Nullable
    public PressurePlateBlock getPressurePlate() {
        return this.pressure_plate == null ? null : (PressurePlateBlock)this.pressure_plate.get();
    }

    public static class WoodDecoBlock
    extends DecoBlockPack {
        final WoodType woodType;
        String woodName;
        @Nullable
        RegistryObject<Block> hSign = null;
        @Nullable
        RegistryObject<Block> hwSign = null;
        @Nullable
        RegistryObject<Block> wSign = null;
        @Nullable
        RegistryObject<Block> sSign = null;
        @Nullable
        RegistryObject<Block> door = null;
        @Nullable
        RegistryObject<Block> trapdoor = null;
        @Nullable
        RegistryObject<Block> fence = null;
        @Nullable
        RegistryObject<Block> fence_gate = null;
        @Nullable
        RegistryObject<Block> button = null;

        public WoodDecoBlock(DeferredRegister<Block> blocks, String basename, WoodType type, BlockBehaviour.Properties props) {
            super(blocks, basename, props);
            this.woodName = type.f_61839_().split(":")[1];
            this.woodType = type;
        }

        public WoodDecoBlock addSign() {
            this.sSign = Registry.BLOCKS.register(this.woodName + "_standing_sign", () -> new StandingSignBlock(this.props, this.woodType));
            this.wSign = Registry.BLOCKS.register(this.woodName + "_wall_sign", () -> new WallSignBlock(this.props, this.woodType));
            this.hSign = Registry.BLOCKS.register(this.woodName + "_hanging_sign", () -> new CeilingHangingSignBlock(this.props, this.woodType));
            this.hwSign = Registry.BLOCKS.register(this.woodName + "_hanging_wall_sign", () -> new WallHangingSignBlock(this.props, this.woodType));
            Registry.ITEMS.register(this.woodName + "_sign", () -> new SignItem(Registry.itemProps(), (Block)this.sSign.get(), (Block)this.wSign.get()));
            Registry.ITEMS.register(this.woodName + "_hanging_sign", () -> new HangingSignItem((Block)this.hSign.get(), (Block)this.hwSign.get(), Registry.itemProps()));
            return this;
        }

        public WoodDecoBlock addButton() {
            this.button = Registry.addBlock(this.woodName + "_button", () -> new ButtonBlock(this.props, BlockSetType.f_271528_, 30, true));
            return this;
        }

        public WoodDecoBlock addFence() {
            this.fence = Registry.addBlock(this.baseBlockName + "_fence", () -> new FenceBlock(this.props));
            this.fence_gate = Registry.addBlock(this.baseBlockName + "_fence_gate", () -> new FenceGateBlock(this.props, WoodType.f_61835_));
            return this;
        }

        public WoodDecoBlock addPressurePlate() {
            this.pressure_plate = Registry.addBlock(this.woodName + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, this.props, BlockSetType.f_271528_));
            return this;
        }

        public WoodDecoBlock addDoors() {
            this.door = Registry.addBlock(this.woodName + "_door", () -> new DoorBlock(this.props, BlockSetType.f_271528_));
            this.trapdoor = Registry.addBlock(this.woodName + "_trapdoor", () -> new TrapDoorBlock(this.props, BlockSetType.f_271528_));
            return this;
        }

        public Block getFence() {
            return this.fence == null ? null : (Block)this.fence.get();
        }

        public Block getFenceGate() {
            return this.fence_gate == null ? null : (Block)this.fence_gate.get();
        }

        @Nullable
        public ButtonBlock getButton() {
            return this.button == null ? null : (ButtonBlock)this.button.get();
        }

        @Nullable
        public DoorBlock getDoor() {
            return this.door == null ? null : (DoorBlock)this.door.get();
        }

        @Nullable
        public TrapDoorBlock getTrapdoor() {
            return this.trapdoor == null ? null : (TrapDoorBlock)this.trapdoor.get();
        }

        @Nullable
        public StandingSignBlock getStandingSign() {
            return this.sSign == null ? null : (StandingSignBlock)this.sSign.get();
        }

        @Nullable
        public WallSignBlock getWallSign() {
            return this.wSign == null ? null : (WallSignBlock)this.wSign.get();
        }

        @Nullable
        public CeilingHangingSignBlock getHangingSign() {
            return this.hSign == null ? null : (CeilingHangingSignBlock)this.hSign.get();
        }

        @Nullable
        public WallHangingSignBlock getHangingWallSign() {
            return this.hwSign == null ? null : (WallHangingSignBlock)this.hwSign.get();
        }
    }
}

