/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.entity.ChantCasterEntity;
import elucent.eidolon.registries.Signs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class AttemptCastPacket {
    final List<Sign> runes = new ArrayList<Sign>();
    final UUID uuid;

    public AttemptCastPacket(Player player, List<Sign> runes) {
        this.runes.addAll(runes);
        this.uuid = player.m_20148_();
    }

    public AttemptCastPacket(UUID uuid, List<Sign> runes) {
        this.runes.addAll(runes);
        this.uuid = uuid;
    }

    public static void encode(AttemptCastPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.runes.size());
        for (int i = 0; i < object.runes.size(); ++i) {
            buffer.m_130072_(object.runes.get(i).getRegistryName().toString(), 255);
        }
        buffer.m_130077_(object.uuid);
    }

    public static AttemptCastPacket decode(FriendlyByteBuf buffer) {
        int n = buffer.readInt();
        ArrayList<Sign> runes = new ArrayList<Sign>();
        for (int i = 0; i < n; ++i) {
            runes.add(Signs.find(new ResourceLocation(buffer.m_130136_(255))));
        }
        return new AttemptCastPacket(buffer.m_130259_(), runes);
    }

    public static void consume(AttemptCastPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER);
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            if ((player = world.m_46003_(packet.uuid)) != null) {
                ChantCasterEntity.createChanter((Player)player, world, packet.runes);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

