/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.research.ResearchTask;
import elucent.eidolon.gui.ResearchTableContainer;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.ResearchActionPacket;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Researches;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ResearchTableScreen
extends AbstractContainerScreen<ResearchTableContainer> {
    private static final ResourceLocation RESEARCH_TABLE_TEXTURE = new ResourceLocation("eidolon", "textures/gui/research_table.png");

    public ResearchTableScreen(ResearchTableContainer table, Inventory inv, Component p_i51097_3_) {
        super((AbstractContainerMenu)table, inv, p_i51097_3_);
        this.f_97727_ = 224;
        this.f_97726_ = 192;
    }

    public void m_88315_(@NotNull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrixStack);
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_280003_(@NotNull GuiGraphics matrixStack, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_TABLE_TEXTURE);
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        double mouseX = Minecraft.m_91087_().f_91067_.m_91589_();
        double mouseY = Minecraft.m_91087_().f_91067_.m_91594_();
        mouseX = mouseX * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_();
        mouseY = mouseY * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_();
        if (((Slot)((ResearchTableContainer)this.f_97732_).f_38839_.get(0)).m_7993_().m_41720_() == Registry.RESEARCH_NOTES.get() && ((ResearchTableContainer)this.f_97732_).getProgress() == 0) {
            ItemStack notes = ((Slot)((ResearchTableContainer)this.f_97732_).f_38839_.get(0)).m_7993_();
            if (!notes.m_41782_() || !notes.m_41783_().m_128441_("research")) {
                return;
            }
            Research r = Researches.find(new ResourceLocation(notes.m_41783_().m_128461_("research")));
            if (r == null) {
                return;
            }
            int nstars = r.getStars();
            int done = notes.m_41783_().m_128451_("stepsDone");
            if (done < nstars) {
                List<ResearchTask> tasks = r.getTasks(((ResearchTableContainer)this.f_97732_).getSeed(notes), notes.m_41783_().m_128451_("stepsDone"));
                int slotStart = 38;
                for (int k = 0; k < tasks.size(); ++k) {
                    ResearchTask task = tasks.get(k);
                    int xx = 164;
                    int yy = 16 + 36 * k;
                    if (!this.m_6774_(xx + 10, yy + 6, 20, 20, mouseX, mouseY)) continue;
                    task.drawTooltip(matrixStack, this, mouseX - (double)i, mouseY - (double)j);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_TABLE_TEXTURE);
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (((Slot)((ResearchTableContainer)this.f_97732_).f_38839_.get(0)).m_7993_().m_41720_() == Registry.RESEARCH_NOTES.get() && ((ResearchTableContainer)this.f_97732_).getProgress() == 0) {
            ItemStack notes = ((Slot)((ResearchTableContainer)this.f_97732_).f_38839_.get(0)).m_7993_();
            if (!notes.m_41782_() || !notes.m_41783_().m_128441_("research")) {
                return false;
            }
            Research r = Researches.find(new ResourceLocation(notes.m_41783_().m_128461_("research")));
            if (r == null) {
                return false;
            }
            List<ResearchTask> tasks = r.getTasks(((ResearchTableContainer)this.f_97732_).getSeed(notes), notes.m_41783_().m_128451_("stepsDone"));
            int slotStart = 38;
            for (int k = 0; k < tasks.size(); ++k) {
                ResearchTask task = tasks.get(k);
                int xx = 164;
                int yy = 16 + 36 * k;
                ResearchTask.CompletenessResult isComplete = task.isComplete(this.f_97732_, (Player)Minecraft.m_91087_().f_91074_, slotStart);
                if (isComplete.complete() && this.m_6774_(xx + task.getWidth() - 30, yy + 9, 20, 13, mouseX, mouseY)) {
                    Networking.sendToServer(new ResearchActionPacket(ResearchActionPacket.Action.SUBMIT_GOAL, k));
                    return true;
                }
                slotStart = isComplete.nextSlot();
            }
            int nstars = r.getStars();
            int done = notes.m_41783_().m_128451_("stepsDone");
            if (done >= nstars && this.m_6774_(75, 51, 17, 14, mouseX, mouseY) && !((ResearchTableContainer)this.f_97732_).m_38853_(1).m_7993_().m_41619_()) {
                Networking.sendToServer(new ResearchActionPacket(ResearchActionPacket.Action.STAMP));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6597_(@Nullable Slot p_97778_, int p_97779_, int p_97780_, @NotNull ClickType p_97781_) {
        if (p_97779_ >= ((ResearchTableContainer)this.f_97732_).f_38839_.size() || p_97778_ == null) {
            return;
        }
        super.m_6597_(p_97778_, p_97779_, p_97780_, p_97781_);
    }

    protected void m_7286_(@NotNull GuiGraphics matrixStack, float partialTicks, int x, int y) {
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        double mouseX = Minecraft.m_91087_().f_91067_.m_91589_();
        double mouseY = Minecraft.m_91087_().f_91067_.m_91594_();
        mouseX = mouseX * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_();
        mouseY = mouseY * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_();
        if (((Slot)((ResearchTableContainer)this.f_97732_).f_38839_.get(0)).m_7993_().m_41720_() == Registry.RESEARCH_NOTES.get()) {
            ItemStack notes = ((Slot)((ResearchTableContainer)this.f_97732_).f_38839_.get(0)).m_7993_();
            if (!notes.m_41782_() || !notes.m_41783_().m_128441_("research")) {
                return;
            }
            Research r = Researches.find(new ResourceLocation(notes.m_41783_().m_128461_("research")));
            if (r == null) {
                return;
            }
            int progress = ((ResearchTableContainer)this.f_97732_).getProgress();
            int amt = progress * 104 / 200;
            if (progress > 0) {
                matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + 137, j + 17 + amt, 192, 92 + amt, 9, 104 - amt);
            }
            int nstars = r.getStars();
            int done = notes.m_41783_().m_128451_("stepsDone");
            if (done < nstars && progress == 0) {
                List<ResearchTask> tasks = r.getTasks(((ResearchTableContainer)this.f_97732_).getSeed(notes), notes.m_41783_().m_128451_("stepsDone"));
                int slotStart = 38;
                for (int k = 0; k < tasks.size(); ++k) {
                    ResearchTask task = tasks.get(k);
                    int xx = 164;
                    int yy = 16 + 36 * k;
                    matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + xx, j + yy, 80, 224, 8, 32);
                    matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + xx + 8, j + yy, 112, 224, 24, 32);
                    task.drawIcon(matrixStack, RESEARCH_TABLE_TEXTURE, i + xx + 12, j + yy + 8);
                    task.drawCustom(matrixStack, RESEARCH_TABLE_TEXTURE, i + xx + 32, j + yy);
                    ResearchTask.CompletenessResult isComplete = task.isComplete(this.f_97732_, (Player)Minecraft.m_91087_().f_91074_, slotStart);
                    if (isComplete.complete()) {
                        if (this.m_6774_(xx + task.getWidth() - 30, yy + 9, 20, 13, mouseX, mouseY)) {
                            matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 32, j + yy, 184, 224, 24, 32);
                        } else {
                            matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 32, j + yy, 160, 224, 24, 32);
                        }
                    } else {
                        matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 32, j + yy, 136, 224, 24, 32);
                    }
                    matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 8, j + yy, 96, 224, 8, 32);
                    slotStart = isComplete.nextSlot();
                }
            }
            int starsY = 61 + 5 * nstars;
            for (int k = 0; k < nstars; ++k) {
                if (k < done) {
                    matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + 152, j + starsY - k * 10, 201, 82, 9, 10);
                    continue;
                }
                matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + 152, j + starsY - k * 10, 192, 82, 9, 10);
            }
            if (done >= nstars && !((ResearchTableContainer)this.f_97732_).m_38853_(1).m_7993_().m_41619_()) {
                if (this.m_6774_(75, 51, 17, 14, mouseX, mouseY)) {
                    matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + 73, j + 49, 234, 64, 21, 18);
                } else {
                    matrixStack.m_280218_(RESEARCH_TABLE_TEXTURE, i + 73, j + 49, 213, 64, 21, 18);
                }
            }
        }
    }
}

