/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import elucent.eidolon.api.IDyeable;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.item.model.WarlockArmorModel;
import elucent.eidolon.registries.EidolonAttributes;
import elucent.eidolon.registries.Registry;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class WarlockRobesItem
extends ArmorItem
implements IDyeable {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};

    public WarlockRobesItem(ArmorItem.Type slot, Item.Properties builderIn) {
        super((ArmorMaterial)Material.INSTANCE, slot, builderIn);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        Component og = super.m_7626_(pStack);
        if (!pStack.m_41782_() || !pStack.m_41783_().m_128441_("color")) {
            return og;
        }
        return Component.m_237113_((String)(og.getString() + " (" + Component.m_237115_((String)this.getColor(pStack).m_41065_()).getString() + ")"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public WarlockArmorModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
                float pticks = Minecraft.m_91087_().m_91296_();
                float f = Mth.m_14189_((float)pticks, (float)entity.f_20884_, (float)entity.f_20883_);
                float f1 = Mth.m_14189_((float)pticks, (float)entity.f_20886_, (float)entity.f_20885_);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.m_14179_((float)pticks, (float)entity.f_19860_, (float)entity.m_146909_());
                ClientRegistry.WARLOCK_ARMOR_MODEL.slot = WarlockRobesItem.this.m_40402_();
                ClientRegistry.WARLOCK_ARMOR_MODEL.copyFromDefault(_default);
                ClientRegistry.WARLOCK_ARMOR_MODEL.m_6973_(entity, entity.f_267362_.m_267756_(), entity.f_267362_.m_267731_(), (float)entity.f_19797_ + pticks, netHeadYaw, netHeadPitch);
                return ClientRegistry.WARLOCK_ARMOR_MODEL;
            }
        });
    }

    private DyeColor getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("color") ? DyeColor.m_41053_((int)tag.m_128451_("color")) : DyeColor.BLUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        DyeColor dyeColor = this.getColor(stack);
        return "eidolon:textures/entity/warlock_robes/" + dyeColor.m_41065_() + ".png";
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        Multimap map = super.m_7167_(pEquipmentSlot);
        if (pEquipmentSlot == EquipmentSlot.HEAD && this == Registry.WARLOCK_HAT.get()) {
            UUID uuid = (UUID)f_265987_.get(this.f_265916_);
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(map);
            builder.put((Object)((Attribute)EidolonAttributes.MAGIC_POWER.get()), (Object)new AttributeModifier(uuid, "eidolon:warlock_hat", 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
            map = builder.build();
        }
        return map;
    }

    public static class Material
    implements ArmorMaterial {
        public static final Material INSTANCE = new Material();

        public int m_266425_(ArmorItem.Type slot) {
            return MAX_DAMAGE_ARRAY[slot.m_266308_().m_20749_()] * 21;
        }

        public int m_7366_(ArmorItem.Type slot) {
            return switch (slot) {
                case ArmorItem.Type.CHESTPLATE -> 7;
                case ArmorItem.Type.HELMET -> 3;
                case ArmorItem.Type.BOOTS -> 2;
                default -> 0;
            };
        }

        public int m_6646_() {
            return 25;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return ArmorMaterials.LEATHER.m_7344_();
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Registry.WICKED_WEAVE.get())});
        }

        @NotNull
        public String m_6082_() {
            return "eidolon:warlock_robes";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

