/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.common.item.IWingsItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RavenCloakModel
extends HumanoidModel<LivingEntity> {
    final ModelPart root;
    final ModelPart cloak;
    final ModelPart wings;
    final ModelPart leftWing;
    final ModelPart rightWing;

    public RavenCloakModel(ModelPart root) {
        super(root);
        this.root = root;
        this.cloak = root.m_171324_("body").m_171324_("cloak");
        this.wings = root.m_171324_("body").m_171324_("wings");
        this.leftWing = this.wings.m_171324_("left_wing");
        this.rightWing = this.wings.m_171324_("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition head = root.m_171599_("head", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition hood = head.m_171599_("hood", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.5f, -10.5f, -4.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_feather1 = hood.m_171599_("left_feather1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)-3.0f, (float)-2.0f, (float)2.0944f, (float)0.0f, (float)0.5236f));
        PartDefinition left_feather2 = hood.m_171599_("left_feather2", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)-3.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)0.7854f));
        PartDefinition left_feather3 = hood.m_171599_("left_feather3", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)-2.0f, (float)4.0f, (float)1.0472f, (float)0.0f, (float)0.5236f));
        PartDefinition right_feather1 = hood.m_171599_("right_feather1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-3.0f, (float)-2.0f, (float)2.0944f, (float)0.0f, (float)-0.5236f));
        PartDefinition right_feather2 = hood.m_171599_("right_feather2", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-3.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)-0.7854f));
        PartDefinition right_feather3 = hood.m_171599_("right_feather3", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-2.0f, (float)4.0f, (float)1.0472f, (float)0.0f, (float)-0.5236f));
        PartDefinition beak = hood.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171488_(-2.5f, 0.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.0f, (float)-5.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cloak = body.m_171599_("cloak", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition left_cloak = cloak.m_171599_("left_cloak", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(-0.5f, -4.0f, -4.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.5f, (float)1.0f, (float)-3.0f, (float)0.1309f, (float)-0.1309f, (float)-0.1309f));
        PartDefinition right_cloak = cloak.m_171599_("right_cloak", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-11.5f, -4.0f, -4.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)1.0f, (float)-3.0f, (float)0.1309f, (float)0.1309f, (float)0.1309f));
        PartDefinition wings = body.m_171599_("wings", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition upper_left_cloak = wings.m_171599_("upper_left_cloak", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(0.5f, -4.0f, -4.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)-3.0f, (float)0.1309f, (float)-0.1309f, (float)-0.5236f));
        PartDefinition upper_right_cloak = wings.m_171599_("upper_right_cloak", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-12.5f, -4.0f, -4.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)4.0f, (float)-3.0f, (float)0.1309f, (float)0.1309f, (float)0.5236f));
        PartDefinition left_wing = wings.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171488_(0.0f, 0.0f, -2.0f, 12.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(48, 41).m_171488_(-4.0f, 8.0f, -1.0f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)5.0f, (float)0.0f, (float)-0.5236f, (float)-0.3927f));
        PartDefinition left_wing_mid = left_wing.m_171599_("left_wing_mid", CubeListBuilder.m_171558_().m_171514_(72, 10).m_171488_(0.0f, 0.0f, -1.0f, 12.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 27).m_171488_(-1.0f, 8.0f, -0.5f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)12.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.2618f, (float)0.1309f));
        PartDefinition left_wing_tip = left_wing_mid.m_171599_("left_wing_tip", CubeListBuilder.m_171558_().m_171514_(44, 11).m_171488_(0.0f, 0.0f, -1.0f, 14.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)11.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.5236f, (float)-0.1309f));
        PartDefinition right_wing = wings.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171480_().m_171488_(-12.0f, 0.0f, -2.0f, 12.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 41).m_171480_().m_171488_(-10.0f, 8.0f, -1.0f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)5.0f, (float)0.0f, (float)0.5236f, (float)0.3927f));
        PartDefinition right_wing_mid = right_wing.m_171599_("right_wing_mid", CubeListBuilder.m_171558_().m_171514_(72, 10).m_171480_().m_171488_(-12.0f, 0.0f, -1.0f, 12.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(44, 27).m_171480_().m_171488_(-13.0f, 8.0f, -0.5f, 14.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-12.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)-0.2618f, (float)-0.1309f));
        PartDefinition right_wing_tip = right_wing_mid.m_171599_("right_wing_tip", CubeListBuilder.m_171558_().m_171514_(44, 11).m_171480_().m_171488_(-14.0f, 0.0f, -1.0f, 14.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-11.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-0.5236f, (float)0.1309f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void m_6973_(@NotNull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            float pticks = Minecraft.m_91087_().m_91296_();
            IPlayerData data = (IPlayerData)p.getCapability(IPlayerData.INSTANCE).resolve().get();
            float timeSinceFlying = Mth.m_14036_((float)((float)(p.f_19853_.m_46467_() - data.getFlightStartTime(p)) + pticks), (float)0.0f, (float)10.0f);
            float timeSinceFlapping = Mth.m_14036_((float)((float)(p.f_19853_.m_46467_() - data.getLastFlapTime(p)) + pticks), (float)0.01f, (float)20.0f);
            ModelPart leftMid = this.leftWing.m_171324_("left_wing_mid");
            ModelPart leftTip = leftMid.m_171324_("left_wing_tip");
            ModelPart rightMid = this.rightWing.m_171324_("right_wing_mid");
            ModelPart rightTip = rightMid.m_171324_("right_wing_tip");
            float unfurl = 0.0f;
            timeSinceFlapping /= 20.0f;
            float flap1 = Mth.m_14031_((float)(7.539823f * (timeSinceFlapping -= 0.16666667f))) / (7.539823f * timeSinceFlapping);
            float flap2 = -Mth.m_14031_((float)((float)Math.PI * 2 * Mth.m_14116_((float)(timeSinceFlapping += 0.16666667f))));
            flap2 *= 1.5f - 0.5f * timeSinceFlapping;
            if (data.isFlying(p)) {
                this.cloak.f_104207_ = false;
                this.wings.f_104207_ = true;
                unfurl = (10.0f - timeSinceFlying) / 10.0f;
                unfurl *= unfurl;
                unfurl = 1.0f - unfurl;
            } else {
                this.cloak.f_104207_ = timeSinceFlying >= 10.0f;
                this.wings.f_104207_ = timeSinceFlying < 10.0f;
                unfurl = (10.0f - timeSinceFlying) / 10.0f;
                unfurl *= unfurl;
            }
            float leftWingX = 0.7854f;
            float leftWingY = -0.5236f;
            float leftWingZ = -0.7854f;
            float rightWingX = 0.7854f;
            float rightWingY = 0.5236f;
            float rightWingZ = 0.7854f;
            float leftMidX = 0.0f;
            float leftMidY = 0.2618f;
            float leftTipY = 0.5236f;
            float rightMidX = 0.0f;
            float rightMidY = -0.2618f;
            float rightTipY = -0.5236f;
            if (data.isDashing(p)) {
                int n;
                ItemStack wings = data.getWingsItem(p);
                Item item = wings.m_41720_();
                if (item instanceof IWingsItem) {
                    IWingsItem i = (IWingsItem)item;
                    n = i.getDashTicks(wings);
                } else {
                    n = 0;
                }
                int maxDash = n;
                int dashTicks = data.getDashTicks(p);
                int sinceDashing = maxDash - dashTicks;
                float dashStart = Mth.m_14036_((float)((float)sinceDashing / 10.0f), (float)0.01f, (float)1.0f);
                leftWingZ = Mth.m_14179_((float)dashStart, (float)leftWingZ, (float)0.0f);
                rightWingZ = Mth.m_14179_((float)dashStart, (float)rightWingZ, (float)0.0f);
                leftWingY = Mth.m_14179_((float)dashStart, (float)leftWingZ, (float)0.0f);
                rightWingY = Mth.m_14179_((float)dashStart, (float)rightWingZ, (float)0.0f);
                leftWingX = Mth.m_14179_((float)dashStart, (float)leftWingX, (float)0.2618f);
                rightWingX = Mth.m_14179_((float)dashStart, (float)rightWingX, (float)0.2618f);
            }
            leftWingX = Mth.m_14179_((float)flap1, (float)leftWingX, (float)1.5708f);
            leftWingY = Mth.m_14179_((float)flap1, (float)leftWingY, (float)1.047f);
            leftWingZ = Mth.m_14179_((float)flap1, (float)leftWingZ, (float)0.5236f);
            leftMidY = Mth.m_14179_((float)flap2, (float)leftMidY, (float)0.7854f);
            rightWingX = Mth.m_14179_((float)flap1, (float)rightWingX, (float)1.5708f);
            rightWingY = Mth.m_14179_((float)flap1, (float)rightWingY, (float)-1.047f);
            rightWingZ = Mth.m_14179_((float)flap1, (float)rightWingZ, (float)-0.5236f);
            rightMidY = Mth.m_14179_((float)flap2, (float)rightMidY, (float)-0.7854f);
            leftWingX = Mth.m_14179_((float)unfurl, (float)0.0f, (float)leftWingX);
            leftWingY = Mth.m_14179_((float)unfurl, (float)0.2618f, (float)leftWingY);
            leftWingZ = Mth.m_14179_((float)unfurl, (float)-0.3927f, (float)leftWingZ);
            leftMidY = Mth.m_14179_((float)unfurl, (float)1.4399f, (float)leftMidY);
            leftTipY = Mth.m_14179_((float)unfurl, (float)1.5708f, (float)leftTipY);
            rightWingX = Mth.m_14179_((float)unfurl, (float)0.0f, (float)rightWingX);
            rightWingY = Mth.m_14179_((float)unfurl, (float)-0.2618f, (float)rightWingY);
            rightWingZ = Mth.m_14179_((float)unfurl, (float)0.3927f, (float)rightWingZ);
            rightMidY = Mth.m_14179_((float)unfurl, (float)-1.4399f, (float)rightMidY);
            rightTipY = Mth.m_14179_((float)unfurl, (float)-1.5708f, (float)rightTipY);
            if (p.m_6047_()) {
                leftWingY += 0.3927f;
                rightWingY -= 0.3927f;
                leftWingZ += 0.3927f;
                rightWingZ -= 0.3927f;
            }
            float clampedDY = (float)Mth.m_14008_((double)p.m_20184_().f_82480_, (double)-0.5, (double)0.5);
            rightWingZ -= clampedDY * 0.5236f;
            this.leftWing.f_104203_ = leftWingX;
            this.leftWing.f_104204_ = leftWingY;
            this.leftWing.f_104205_ = leftWingZ += clampedDY * 0.5236f;
            leftMid.f_104204_ = leftMidY;
            leftTip.f_104204_ = leftTipY;
            this.rightWing.f_104203_ = rightWingX;
            this.rightWing.f_104204_ = rightWingY;
            this.rightWing.f_104205_ = rightWingZ;
            rightMid.f_104204_ = rightMidY;
            rightTip.f_104204_ = rightTipY;
        }
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.root.m_171324_("head"));
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.root.m_171324_("body"));
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

