/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.util.RegistryUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChantConversionRecipe
implements Recipe<Container> {
    ResourceLocation id;
    public Ingredient input;
    ItemStack result;
    public float minDevotion;
    @Nullable
    public ResourceLocation deity;

    public ChantConversionRecipe(ResourceLocation id, Ingredient input, ItemStack result, float minDevotion, @Nullable ResourceLocation Deity2) {
        this.id = id;
        this.input = input;
        this.result = result;
        this.minDevotion = minDevotion;
        this.deity = Deity2;
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.CHANT_CONVERSION_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.CHANT_CONVERSION_TYPE.get();
    }

    public JsonObject toJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:chant_conversion");
        jsonobject.add("input", this.input.m_43942_());
        jsonobject.addProperty("min_devotion", (Number)Float.valueOf(this.minDevotion));
        if (this.deity != null) {
            jsonobject.addProperty("deity", this.deity.toString());
        }
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", RegistryUtil.getRegistryName(this.result.m_41720_()).toString());
        int count = this.result.m_41613_();
        if (count > 1) {
            resultObj.addProperty("count", (Number)count);
        }
        jsonobject.add("output", (JsonElement)resultObj);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<ChantConversionRecipe> {
        @NotNull
        public ChantConversionRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            float minDevotion = GsonHelper.m_13820_((JsonObject)pSerializedRecipe, (String)"min_devotion", (float)0.0f);
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            ResourceLocation deity = pSerializedRecipe.has("deity") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)pSerializedRecipe, (String)"deity")) : null;
            return new ChantConversionRecipe(pRecipeId, input, output, minDevotion, deity);
        }

        @Nullable
        public ChantConversionRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack output = pBuffer.m_130267_();
            float minDevotion = pBuffer.readFloat();
            ResourceLocation deity = pBuffer.readBoolean() ? pBuffer.m_130281_() : null;
            return new ChantConversionRecipe(pRecipeId, input, output, minDevotion, deity);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull ChantConversionRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.writeFloat(pRecipe.minDevotion);
            pBuffer.writeBoolean(pRecipe.deity != null);
            if (pRecipe.deity != null) {
                pBuffer.m_130085_(pRecipe.deity);
            }
        }
    }
}

