/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.registries.Spells;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SpellCastPacket {
    final SignSequence seq;
    final Spell spell;
    final BlockPos pos;
    final UUID uuid;

    public SpellCastPacket(Player player, BlockPos pos, Spell spell, SignSequence seq) {
        this.seq = seq;
        this.pos = pos;
        this.spell = spell;
        this.uuid = player.m_20148_();
    }

    public SpellCastPacket(UUID uuid, BlockPos pos, ResourceLocation location, SignSequence seq) {
        this.seq = seq;
        this.pos = pos;
        this.spell = Spells.find(location);
        this.uuid = uuid;
    }

    public static void encode(SpellCastPacket object, FriendlyByteBuf buffer) {
        buffer.m_130070_(object.spell.getRegistryName().toString());
        buffer.m_130079_(object.seq.serializeNbt());
        buffer.m_130077_(object.uuid);
        buffer.m_130064_(object.pos);
    }

    public static SpellCastPacket decode(FriendlyByteBuf buffer) {
        ResourceLocation spell = new ResourceLocation(buffer.m_130277_());
        SignSequence seq = SignSequence.deserializeNbt(buffer.m_130260_());
        return new SpellCastPacket(buffer.m_130259_(), buffer.m_130135_(), spell, seq);
    }

    public static void consume(SpellCastPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player;
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Eidolon.proxy.getWorld();
            if (world != null && (player = world.m_46003_(packet.uuid)) != null) {
                packet.spell.cast(world, packet.pos, player, packet.seq);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

