/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.compat.apotheosis;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.ench.asm.EnchHooks;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.StepFunction;
import elucent.eidolon.common.item.WandItem;
import elucent.eidolon.compat.apotheosis.HailingAffix;
import elucent.eidolon.compat.apotheosis.TrackingAffix;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public class Apotheosis {
    private static final EquipmentSlot[] wandSlots = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    public static final LootCategory WAND = LootCategory.register((LootCategory)LootCategory.SWORD, (String)"wand", itemStack -> itemStack.m_41720_() instanceof WandItem, (EquipmentSlot[])wandSlots);

    public static boolean isTreasureOnly(Enchantment enchantment) {
        return EnchHooks.isTreasureOnly((Enchantment)enchantment);
    }

    public static int getMaxLevel(Enchantment enchantment) {
        return EnchHooks.getMaxLevel((Enchantment)enchantment);
    }

    public static int affixToAmount(AffixInstance affixInstance) {
        Object object = affixInstance.affix().get();
        if (object instanceof StepScalingAffix) {
            StepScalingAffix scalingAffix = (StepScalingAffix)object;
            return (int)scalingAffix.affixToAmount(affixInstance);
        }
        return 0;
    }

    public static void initialize() {
        AffixRegistry.INSTANCE.registerCodec(new ResourceLocation("eidolon", "tracking"), TrackingAffix.CODEC);
        AffixRegistry.INSTANCE.registerCodec(new ResourceLocation("eidolon", "hailing"), HailingAffix.CODEC);
    }

    public static Pair<Integer, Integer> handleWandAffix(ItemStack stack) {
        int projectileAmount = 1;
        int trackingAmount = 0;
        Map affixes = AffixHelper.getAffixes((ItemStack)stack);
        for (DynamicHolder affix : affixes.keySet()) {
            AffixInstance affixInstance = (AffixInstance)affixes.get(affix);
            if (affix.get() instanceof HailingAffix) {
                projectileAmount += Apotheosis.affixToAmount(affixInstance);
                continue;
            }
            if (!(affix.get() instanceof TrackingAffix)) continue;
            trackingAmount += Apotheosis.affixToAmount(affixInstance);
        }
        return Pair.of((Object)projectileAmount, (Object)trackingAmount);
    }

    public static interface StepScalingAffix {
        @NotNull
        public Map<LootRarity, StepFunction> getValues();

        default public float affixToAmount(LootRarity rarity, float level) {
            return this.getValues().get(rarity).get(level);
        }

        default public float affixToAmount(AffixInstance affixInstance) {
            return this.affixToAmount((LootRarity)affixInstance.rarity().get(), affixInstance.level());
        }
    }
}

