/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MathUtil {
    public static long NIGHT_TIME = 13000L;
    public static long DAY_TIME = 1000L;

    @Nullable
    public static EntityHitResult getLookedAtEntity(Entity entity, int range) {
        Vec3 vec3d = entity.getEyePosition(1.0f);
        Vec3 vec3d1 = entity.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * (double)range, vec3d1.y * (double)range, vec3d1.z * (double)range);
        AABB axisalignedbb = entity.getBoundingBox().expandTowards(vec3d1.scale((double)range)).inflate(1.0, 1.0, 1.0);
        return MathUtil.traceEntities(entity, vec3d, vec3d2, axisalignedbb, e -> !e.isSpectator() && e.isPickable(), range);
    }

    @Nullable
    public static EntityHitResult traceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance) {
        Level world = shooter.level();
        double d0 = distance;
        Entity entity = null;
        Vec3 vec3d = null;
        for (Entity entity1 : world.getEntities(shooter, boundingBox, filter)) {
            Vec3 vec3d1;
            double d1;
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optional = axisalignedbb.clip(startVec, endVec);
            if (axisalignedbb.contains(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.distanceToSqr(vec3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.getRootVehicle() == shooter.getRootVehicle() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3d = vec3d1;
                continue;
            }
            entity = entity1;
            vec3d = vec3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vec3d);
    }

    public static long getNextDaysTime(Level world, long timeOfDay) {
        long dayTime = world.getDayTime();
        long newTime = dayTime + 24000L;
        newTime -= newTime % 24000L;
        return newTime + timeOfDay;
    }
}

